/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.health;

import com.networknt.config.Config;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Map;

@ConfigSchema(configKey="health", configName="health", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class HealthConfig {
    public static final String CONFIG_NAME = "health";
    private static final String ENABLED = "enabled";
    private static final String USE_JSON = "useJson";
    private static final String TIMEOUT = "timeout";
    private static final String DOWNSTREAM_ENABLED = "downstreamEnabled";
    private static final String DOWNSTREAM_HOST = "downstreamHost";
    private static final String DOWNSTREAM_PATH = "downstreamPath";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", defaultValue=true, externalized=true, description="true to enable this middleware handler. By default, the health check is enabled.")
    boolean enabled;
    @BooleanField(configFieldName="useJson", externalizedKeyName="useJson", externalized=true, description="true to return Json format message. By default, it is false. It will only be changed to true if the monitor\ntool only support JSON response body.")
    boolean useJson;
    @IntegerField(configFieldName="timeout", externalizedKeyName="timeout", defaultValue=2000, externalized=true, description="timeout in milliseconds for the health check. If the duration is passed, a failure will return.\nIt is to prevent taking too much time to check subsystems that are not available or timeout.\nAs the health check is used by the control plane for service discovery, by default, one request\nper ten seconds. The quick response time is very important to not block the control plane.")
    int timeout;
    @BooleanField(configFieldName="downstreamEnabled", externalizedKeyName="downstreamEnabled", externalized=true, description="For some of the services like light-proxy, http-sidecar and kafka-sidecar, we might need to check the down\nstream API before return the health status to the invoker. By default, it is not enabled.\nif the health check needs to invoke down streams API. It is false by default.")
    boolean downstreamEnabled;
    @StringField(configFieldName="downstreamHost", externalizedKeyName="downstreamHost", externalized=true, defaultValue="http://localhost:8081", description="down stream API host. http://localhost is the default when used with http-sidecar and kafka-sidecar.")
    String downstreamHost;
    @StringField(configFieldName="downstreamPath", externalizedKeyName="downstreamPath", externalized=true, defaultValue="/health", description="down stream API health check path. This allows the down stream API to have customized path implemented.")
    String downstreamPath;

    private HealthConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private HealthConfig() {
        this(CONFIG_NAME);
    }

    public static HealthConfig load(String configName) {
        return new HealthConfig(configName);
    }

    public static HealthConfig load() {
        return new HealthConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isUseJson() {
        return this.useJson;
    }

    public void setUseJson(boolean useJson) {
        this.useJson = useJson;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isDownstreamEnabled() {
        return this.downstreamEnabled;
    }

    public void setDownstreamEnabled(boolean downstreamEnabled) {
        this.downstreamEnabled = downstreamEnabled;
    }

    public String getDownstreamHost() {
        return this.downstreamHost;
    }

    public void setDownstreamHost(String downstreamHost) {
        this.downstreamHost = downstreamHost;
    }

    public String getDownstreamPath() {
        return this.downstreamPath;
    }

    public void setDownstreamPath(String downstreamPath) {
        this.downstreamPath = downstreamPath;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(ENABLED);
            if (object != null) {
                this.enabled = Config.loadBooleanValue(ENABLED, object);
            }
            if ((object = this.getMappedConfig().get(USE_JSON)) != null) {
                this.useJson = Config.loadBooleanValue(USE_JSON, object);
            }
            if ((object = this.getMappedConfig().get(TIMEOUT)) != null) {
                this.timeout = Config.loadIntegerValue(TIMEOUT, object);
            }
            if ((object = this.getMappedConfig().get(DOWNSTREAM_ENABLED)) != null) {
                this.downstreamEnabled = Config.loadBooleanValue(DOWNSTREAM_ENABLED, object);
            }
            if ((object = this.getMappedConfig().get(DOWNSTREAM_HOST)) != null) {
                this.downstreamHost = (String)object;
            }
            if ((object = this.getMappedConfig().get(DOWNSTREAM_PATH)) != null) {
                this.downstreamPath = (String)object;
            }
        }
    }
}

