/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.config;

import com.networknt.config.ConfigException;
import com.networknt.utility.StringUtils;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlRewriteRule {
    private static final Logger LOG = LoggerFactory.getLogger(UrlRewriteRule.class);
    Pattern pattern;
    String replace;

    public UrlRewriteRule(Pattern pattern, String replace) {
        this.pattern = pattern;
        this.replace = replace;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        this.replace = replace;
    }

    public static UrlRewriteRule convertToUrlRewriteRule(String s2) {
        String[] parts = StringUtils.split(s2, ' ');
        if (parts.length != 2) {
            String error = "The URL rewrite rule " + s2 + " must have two parts";
            if (LOG.isErrorEnabled()) {
                LOG.error(error);
            }
            throw new ConfigException(error);
        }
        return new UrlRewriteRule(Pattern.compile(parts[0]), parts[1]);
    }
}

