/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.config;

import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.StringField;
import com.networknt.utility.Util;
import java.util.ArrayList;
import java.util.List;

public class PathChain {
    private String source;
    @StringField(configFieldName="path", description="The path to match", pattern="^/.*")
    private String path;
    @StringField(configFieldName="method", description="The HTTP method to match", pattern="(?i)^(GET|POST|PUT|DELETE|PATCH|OPTIONS|HEAD|TRACE|CONNECT)$")
    private String method;
    @ArrayField(configFieldName="exec", description="The list of handlers", items=String.class)
    private List<String> exec;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source2) {
        this.source = source2;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<String> getExec() {
        return this.exec;
    }

    public void setExec(List<String> exec) {
        this.exec = exec;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String toString() {
        if (this.path != null) {
            return this.path + "@" + this.method + " \u2192 " + String.valueOf(this.exec);
        }
        return this.source + "() \u2192 " + String.valueOf(this.exec);
    }

    public void validate(String origin) {
        ArrayList<Object> problems = new ArrayList<Object>();
        if (this.source == null) {
            if (this.path == null) {
                problems.add("You must specify either path or source");
                problems.add("It is possible that serviceId is missing from the values.yml and it is mandatory.");
            } else if (this.method == null) {
                problems.add("You must specify method along with path: " + this.path);
            }
        } else {
            if (this.path != null) {
                problems.add("Conflicting source: " + this.source + " and path: " + this.path);
            }
            if (this.method != null) {
                problems.add("Conflicting source: " + this.source + " and method: " + this.method);
            }
        }
        if (this.method != null && !Util.METHODS.contains(this.method.toUpperCase())) {
            problems.add("Invalid HTTP method: " + this.method);
        }
        if (!problems.isEmpty()) {
            throw new RuntimeException("Bad paths element in " + origin + " [ " + String.join((CharSequence)" | ", problems) + " ]");
        }
    }
}

