/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.config;

import com.networknt.utility.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerUtils {
    private static final Logger logger = LoggerFactory.getLogger(HandlerUtils.class);
    public static final String DELIMITER = "@";
    protected static final String INTERNAL_KEY_FORMAT = "%s %s";

    public static String[] findServiceEntry(String searchKey, Map<String, String> mapping) {
        if (logger.isDebugEnabled()) {
            logger.debug("findServiceEntry for " + searchKey);
        }
        String[] result2 = null;
        if (mapping == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("mapping is empty in the configuration.");
            }
            return null;
        }
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            String prefix = entry.getKey();
            if (!searchKey.startsWith(prefix) || searchKey.length() != prefix.length() && searchKey.charAt(prefix.length()) != '/') continue;
            result2 = new String[]{entry.getKey(), entry.getValue()};
            break;
        }
        if (result2 == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("serviceEntry not found!");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("prefix = " + (String)result2[0] + " serviceId = " + (String)result2[1]);
        }
        return result2;
    }

    public static String normalisePath(String requestPath) {
        if (!requestPath.startsWith("/")) {
            return "/" + requestPath;
        }
        return requestPath;
    }

    public static String toInternalKey(String key) {
        String[] tokens = StringUtils.trimToEmpty(key).split(DELIMITER);
        if (tokens.length == 2) {
            return HandlerUtils.toInternalKey(tokens[1], tokens[0]);
        }
        logger.warn("Invalid key {}", (Object)key);
        return key;
    }

    public static String toInternalKey(String method, String path) {
        return String.format(INTERNAL_KEY_FORMAT, method, HandlerUtils.normalisePath(path));
    }
}

