/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.MapField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import com.networknt.handler.config.PathChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configName="handler", configKey="handler", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class HandlerConfig {
    public static final String CONFIG_NAME = "handler";
    private static final Logger logger = LoggerFactory.getLogger(HandlerConfig.class);
    private static final String ENABLED = "enabled";
    private static final String HANDLERS = "handlers";
    private static final String ADDITIONAL_HANDLERS = "additionalHandlers";
    private static final String CHAINS = "chains";
    private static final String ADDITIONAL_CHAINS = "additionalChains";
    private static final String PATHS = "paths";
    private static final String ADDITIONAL_PATHS = "additionalPaths";
    private static final String DEFAULT_HANDLERS = "defaultHandlers";
    private static final String AUDIT_ON_ERROR = "auditOnError";
    private static final String AUDIT_STACK_TRACE = "auditStackTrace";
    private static final String BASE_PATH = "basePath";
    private static final String REPORT_HANDLER_DURATION = "reportHandlerDuration";
    private static final String HANDLER_METRICS_LOG_LEVEL = "handlerMetricsLogLevel";
    private static final String PATH = "path";
    private static final String SOURCE = "source";
    private static final String EXEC = "exec";
    private static final String METHOD = "method";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", defaultValue=true, description="Indicate if the handler middleware is enabled or not.")
    private boolean enabled;
    @BooleanField(configFieldName="auditOnError", externalizedKeyName="auditOnError", externalized=true, description="Configuration for the LightHttpHandler. The handler is the base class  for all middleware, server and health handlers\nset the Status Object in the AUDIT_INFO, for auditing purposes\ndefault, if not set:false")
    private boolean auditOnError;
    @BooleanField(configFieldName="auditStackTrace", externalizedKeyName="auditStackTrace", externalized=true, description="set the StackTrace in the AUDIT_INFO, for auditing purposes\ndefault, if not set:false")
    private boolean auditStackTrace;
    @BooleanField(configFieldName="reportHandlerDuration", externalizedKeyName="reportHandlerDuration", externalized=true, description="Indicate if the handler middleware should report handler duration.")
    private boolean enabledHandlerMetrics;
    @StringField(configFieldName="handlerMetricsLogLevel", externalizedKeyName="handlerMetricsLogLevel", externalized=true, defaultValue="DEBUG", pattern="^(TRACE|DEBUG|INFO|WARN|ERROR)$", description="The log level for the handler metrics.")
    private String handlerMetricsLogLevel;
    @StringField(configFieldName="basePath", externalizedKeyName="basePath", externalized=true, defaultValue="/", description="Base Path of the API endpoints")
    private String basePath;
    @ArrayField(configFieldName="handlers", externalizedKeyName="handlers", externalized=true, description="------------------------------------------------------------------------------\nSupport individual handler chains for each separate endpoint. It allows framework\nhandlers like health check, server info to bypass majority of the middleware handlers\nand allows mixing multiple frameworks like OpenAPI and GraphQL in the same instance.\n\nhandlers  --  list of handlers to be used across chains in this microservice\n              including the routing handlers for ALL endpoints\n          --  format: fully qualified handler class name@optional:given name\nchains    --  allows forming of [1..N] chains, which could be wholly or\n              used to form handler chains for each endpoint\n              ex.: default chain below, reused partially across multiple endpoints\npaths     --  list all the paths to be used for routing within the microservice\n          ----  path: the URI for the endpoint (ex.: path: '/v1/pets')\n          ----  method: the operation in use (ex.: 'post')\n          ----  exec: handlers to be executed -- this element forms the list and\n                      the order of execution for the handlers\n\nIMPORTANT NOTES:\n- to avoid executing a handler, it has to be removed/commented out in the chain\n  or change the enabled:boolean to false for a middleware handler configuration.\n- all handlers, routing handler included, are to be listed in the execution chain\n- for consistency, give a name to each handler; it is easier to refer to a name\n  vs a fully qualified class name and is more elegant\n- you can list in chains the fully qualified handler class names, and avoid using the\n  handlers element altogether\n------------------------------------------------------------------------------", items=String.class)
    private List<String> handlers;
    @MapField(configFieldName="defaultHandlers", externalizedKeyName="defaultHandlers", externalized=true, description="List of defined chains", valueType=List.class)
    private Map<String, List<String>> chains;
    @ArrayField(configFieldName="paths", externalizedKeyName="paths", externalized=true, items=PathChain.class)
    private List<PathChain> paths;
    @ArrayField(configFieldName="defaultHandlers", externalizedKeyName="defaultHandlers", externalized=true, description="If there is no matched path, then it goes here first. If this is not set, then an error\nwill be returned.", items=String.class)
    private List<String> defaultHandlers;
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();

    private HandlerConfig() {
        this(CONFIG_NAME);
    }

    private HandlerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
        this.setConfigMap();
    }

    public static HandlerConfig load() {
        return new HandlerConfig();
    }

    public static HandlerConfig load(String configName) {
        return new HandlerConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
        this.setConfigMap();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabledHandlerMetrics() {
        return this.enabledHandlerMetrics;
    }

    public void setEnabledHandlerMetrics(boolean enabledHandlerMetrics) {
        this.enabledHandlerMetrics = enabledHandlerMetrics;
    }

    public String getHandlerMetricsLogLevel() {
        return this.handlerMetricsLogLevel;
    }

    public void setHandlerMetricsLogLevel(String handlerMetricsLogLevel) {
        this.handlerMetricsLogLevel = handlerMetricsLogLevel;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<String> handlers) {
        this.handlers = handlers;
    }

    public Map<String, List<String>> getChains() {
        return this.chains;
    }

    public void setChains(Map<String, List<String>> chains) {
        this.chains = chains;
    }

    public List<PathChain> getPaths() {
        return this.paths;
    }

    public void setPaths(List<PathChain> paths) {
        this.paths = paths;
    }

    public List<String> getDefaultHandlers() {
        return this.defaultHandlers;
    }

    public void setDefaultHandlers(List<String> defaultHandlers) {
        this.defaultHandlers = defaultHandlers;
    }

    public boolean getAuditOnError() {
        return this.auditOnError;
    }

    public void setAuditOnError(boolean auditOnError) {
        this.auditOnError = auditOnError;
    }

    public boolean getAuditStackTrace() {
        return this.auditStackTrace;
    }

    public void setAuditStackTrace(boolean auditStackTrace) {
        this.auditStackTrace = auditStackTrace;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath2) {
        this.basePath = basePath2;
    }

    public boolean isAuditOnError() {
        return this.auditOnError;
    }

    public boolean isAuditStackTrace() {
        return this.auditStackTrace;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        if (this.mappedConfig != null) {
            Object object = this.mappedConfig.get(ENABLED);
            if (object != null) {
                this.enabled = Config.loadBooleanValue(ENABLED, object);
            }
            if ((object = this.mappedConfig.get(REPORT_HANDLER_DURATION)) != null) {
                this.enabledHandlerMetrics = Config.loadBooleanValue(REPORT_HANDLER_DURATION, object);
            }
            if ((object = this.mappedConfig.get(AUDIT_ON_ERROR)) != null) {
                this.auditOnError = Config.loadBooleanValue(AUDIT_ON_ERROR, object);
            }
            if ((object = this.mappedConfig.get(AUDIT_STACK_TRACE)) != null) {
                this.auditStackTrace = Config.loadBooleanValue(AUDIT_STACK_TRACE, object);
            }
            if ((object = this.mappedConfig.get(BASE_PATH)) != null) {
                this.basePath = (String)object;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setConfigList() {
        PathChain pathChain;
        List values2;
        List list;
        String s2;
        Object object;
        if (this.mappedConfig != null && this.mappedConfig.get(HANDLERS) != null) {
            object = this.mappedConfig.get(HANDLERS);
            this.handlers = new ArrayList<String>();
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.handlers = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the handlers json with a list of strings.");
                    }
                } else {
                    this.handlers = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else {
                if (!(object instanceof List)) throw new ConfigException("handlers must be a string or a list of strings.");
                list = (List)object;
                this.handlers.addAll(list);
            }
            if (this.mappedConfig.get(ADDITIONAL_HANDLERS) != null) {
                object = this.mappedConfig.get(ADDITIONAL_HANDLERS);
                if (object instanceof String) {
                    s2 = (String)object;
                    s2 = s2.trim();
                    if (logger.isTraceEnabled()) {
                        logger.trace("s = " + s2);
                    }
                    if (s2.startsWith("[")) {
                        try {
                            this.handlers.addAll(Config.getInstance().getMapper().readValue(s2, new TypeReference<Collection<? extends String>>(){}));
                        }
                        catch (Exception e) {
                            throw new ConfigException("could not parse the additionalHandlers json with a list of strings.");
                        }
                    } else {
                        this.handlers.addAll(Arrays.asList(s2.split("\\s*,\\s*")));
                    }
                } else {
                    if (!(object instanceof List)) throw new ConfigException("additionalHandlers must be a string or a list of strings.");
                    list = (List)object;
                    this.handlers.addAll(list);
                }
            }
        }
        if (this.mappedConfig != null && this.mappedConfig.get(DEFAULT_HANDLERS) != null) {
            object = this.mappedConfig.get(DEFAULT_HANDLERS);
            this.defaultHandlers = new ArrayList<String>();
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.defaultHandlers = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the defaultHandlers json with a list of strings.");
                    }
                } else {
                    this.defaultHandlers = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else {
                if (!(object instanceof List)) throw new ConfigException("defaultHandlers must be a string or a list of strings.");
                list = (List)object;
                this.defaultHandlers.addAll(list);
            }
        }
        if (this.mappedConfig == null || this.mappedConfig.get(PATHS) == null) return;
        object = this.mappedConfig.get(PATHS);
        this.paths = new ArrayList<PathChain>();
        if (object instanceof String) {
            s2 = (String)object;
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("paths s = " + s2);
            }
            if (!s2.startsWith("[")) throw new ConfigException("paths must be a list of string object map.");
            try {
                this.paths = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<PathChain>>(){});
            }
            catch (Exception e) {
                throw new ConfigException("could not parse the paths json with a list of string and object.");
            }
        } else {
            if (!(object instanceof List)) throw new ConfigException("paths must be a list of string object map.");
            values2 = (List)object;
            for (Map value : values2) {
                pathChain = new PathChain();
                pathChain.setPath((String)value.get(PATH));
                pathChain.setSource((String)value.get(SOURCE));
                pathChain.setMethod((String)value.get(METHOD));
                pathChain.setExec((List)value.get(EXEC));
                this.paths.add(pathChain);
            }
        }
        if (this.mappedConfig.get(ADDITIONAL_PATHS) == null) return;
        object = this.mappedConfig.get(ADDITIONAL_PATHS);
        if (object instanceof String) {
            s2 = (String)object;
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("s = " + s2);
            }
            if (!s2.startsWith("[")) throw new ConfigException("additionalPaths must be a list of string object map.");
            try {
                this.paths.addAll((Collection<PathChain>)Config.getInstance().getMapper().readValue(s2, new TypeReference<List<PathChain>>(){}));
                return;
            }
            catch (Exception e) {
                throw new ConfigException("could not parse the additionalPaths json with a list of string and object.");
            }
        } else {
            if (!(object instanceof List)) throw new ConfigException("additionalPaths must be a list of string object map.");
            values2 = (List)object;
            for (Map value : values2) {
                pathChain = new PathChain();
                pathChain.setPath((String)value.get(PATH));
                pathChain.setSource((String)value.get(SOURCE));
                pathChain.setMethod((String)value.get(METHOD));
                pathChain.setExec((List)value.get(EXEC));
                this.paths.add(pathChain);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setConfigMap() {
        List<String> list;
        String s2;
        Object value;
        String key;
        Map map;
        String s3;
        Object chainsObject;
        if (this.mappedConfig == null || this.mappedConfig.get(CHAINS) == null || (chainsObject = this.mappedConfig.get(CHAINS)) == null) return;
        if (chainsObject instanceof String) {
            s3 = (String)chainsObject;
            s3 = s3.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("chains s = " + s3);
            }
            if (!s3.startsWith("{")) throw new ConfigException("could not parse the chains json with a map of string and list of strings.");
            try {
                this.chains = Config.getInstance().getMapper().readValue(s3, new TypeReference<Map<String, List<String>>>(){});
            }
            catch (Exception e) {
                throw new ConfigException("could not parse the chains json with a map of string and list of strings.");
            }
        } else {
            if (!(chainsObject instanceof Map)) throw new ConfigException("chains must be a string object map.");
            this.chains = new HashMap<String, List<String>>();
            map = (Map)chainsObject;
            for (Map.Entry entry : map.entrySet()) {
                key = (String)entry.getKey();
                value = entry.getValue();
                if (value instanceof String) {
                    s2 = (String)value;
                    s2 = s2.trim();
                    if (logger.isTraceEnabled()) {
                        logger.trace("s = " + s2);
                    }
                    if (s2.startsWith("[")) {
                        try {
                            list = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                        }
                        catch (Exception e) {
                            throw new ConfigException("could not parse the chains json with a map of string and list of strings.");
                        }
                    } else {
                        list = Arrays.asList(s2.split("\\s*,\\s*"));
                    }
                    this.chains.put(key, list);
                    continue;
                }
                if (!(value instanceof List)) throw new ConfigException("chains must be a string object map.");
                this.chains.put(key, (List)value);
            }
        }
        if (this.mappedConfig.get(ADDITIONAL_CHAINS) == null) return;
        chainsObject = this.mappedConfig.get(ADDITIONAL_CHAINS);
        if (chainsObject instanceof String) {
            s3 = (String)chainsObject;
            s3 = s3.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("s = " + s3);
            }
            if (!s3.startsWith("{")) throw new ConfigException("additionalChains must be a string object map.");
            try {
                this.chains.putAll(Config.getInstance().getMapper().readValue(s3, new TypeReference<Map<String, List<String>>>(){}));
                return;
            }
            catch (Exception e) {
                throw new ConfigException("could not parse the additionalChains json with a map of string and list of strings.");
            }
        } else {
            if (!(chainsObject instanceof Map)) throw new ConfigException("additionalChains must be a string object map.");
            map = (Map)chainsObject;
            for (Map.Entry entry : map.entrySet()) {
                key = (String)entry.getKey();
                value = entry.getValue();
                if (value instanceof String) {
                    s2 = (String)value;
                    s2 = s2.trim();
                    if (logger.isTraceEnabled()) {
                        logger.trace("s = " + s2);
                    }
                    if (s2.startsWith("[")) {
                        try {
                            list = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                        }
                        catch (Exception e) {
                            throw new ConfigException("could not parse the additionalChains json with a map of string and list of strings.");
                        }
                    } else {
                        list = Arrays.asList(s2.split("\\s*,\\s*"));
                    }
                    this.chains.put(key, list);
                    continue;
                }
                if (!(value instanceof List)) throw new ConfigException("additionalChains must be a string object map.");
                this.chains.put(key, (List)value);
            }
        }
    }
}

