/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.conduit;

import com.networknt.handler.ResponseInterceptor;
import com.networknt.service.SingletonServiceFactory;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public class ContentStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final Logger LOG = LoggerFactory.getLogger(ContentStreamSinkConduit.class);
    private final StreamSinkConduit _next;
    private final ResponseInterceptor[] interceptors;

    public ContentStreamSinkConduit(StreamSinkConduit next, HttpServerExchange exchange) {
        super(next);
        this._next = next;
        this.interceptors = SingletonServiceFactory.getBeans(ResponseInterceptor.class);
        try {
            if (this.interceptors != null && this.interceptors.length > 0) {
                for (ResponseInterceptor interceptor : this.interceptors) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Executing interceptor " + String.valueOf(interceptor.getClass()));
                    }
                    interceptor.handleRequest(exchange);
                }
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error executing interceptors", e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this._next.write(src);
    }

    @Override
    public long write(ByteBuffer[] dsts, int offs, int len) throws IOException {
        return this._next.write(dsts, offs, len);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this._next.transferFrom(src, position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel src, long count, ByteBuffer throughBuffer) throws IOException {
        return this._next.transferFrom(src, count, throughBuffer);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return this._next.writeFinal(src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this._next.writeFinal(srcs, offset, length);
    }

    @Override
    public void terminateWrites() throws IOException {
        this._next.terminateWrites();
    }
}

