/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.OutputFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configName="response-injection", configKey="response-injection", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class ResponseInjectionConfig {
    private static final Logger logger = LoggerFactory.getLogger(ResponseInjectionConfig.class);
    public static final String CONFIG_NAME = "response-injection";
    private static final String ENABLED = "enabled";
    private static final String APPLIED_BODY_INJECTION_PATH_PREFIXES = "appliedBodyInjectionPathPrefixes";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", externalized=true, defaultValue=true, description="indicator of enabled")
    private boolean enabled;
    @ArrayField(configFieldName="appliedBodyInjectionPathPrefixes", externalizedKeyName="appliedBodyInjectionPathPrefixes", externalized=true, description="response body injection applied path prefixes. Injecting the response body and output into the audit log is very heavy operation,\nand it should only be enabled when necessary or for diagnose session to resolve issues. This list can be updated on the config\nserver or local values.yml, then an API call to the config-reload endpoint to apply the changes from light-portal control pane.\nPlease be aware that big response body will only log the beginning part of it in the audit log and gzip encoded response body can\nnot be injected. Even the body injection is not applied, you can still transform the response for headers, query parameters, path\nparameters etc. The format is a list of strings separated with commas or a JSON list in values.yml definition from config server,\nor you can use yaml format in this file or values.yaml on local filesystem. The following are the examples.\nresponse-injection.appliedBodyInjectionPathPrefixes: [\"/v1/cats\", \"/v1/dogs\"]\nresponse-injection.appliedBodyInjectionPathPrefixes: /v1/cats, /v1/dogs\nresponse-injection.appliedBodyInjectionPathPrefixes:\n  - /v1/cats\n  - /v1/dogs", items=String.class)
    private List<String> appliedBodyInjectionPathPrefixes;
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();

    public ResponseInjectionConfig() {
        this(CONFIG_NAME);
    }

    public ResponseInjectionConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    static ResponseInjectionConfig load() {
        return new ResponseInjectionConfig();
    }

    static ResponseInjectionConfig load(String configName) {
        return new ResponseInjectionConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getAppliedBodyInjectionPathPrefixes() {
        return this.appliedBodyInjectionPathPrefixes;
    }

    Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
    }

    private void setConfigList() {
        if (this.mappedConfig != null && this.mappedConfig.get(APPLIED_BODY_INJECTION_PATH_PREFIXES) != null) {
            Object object = this.mappedConfig.get(APPLIED_BODY_INJECTION_PATH_PREFIXES);
            this.appliedBodyInjectionPathPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                String s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.appliedBodyInjectionPathPrefixes = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the appliedBodyInjectionPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.appliedBodyInjectionPathPrefixes = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.appliedBodyInjectionPathPrefixes.add((String)item));
            } else {
                throw new ConfigException("appliedBodyInjectionPathPrefixes must be a string or a list of strings.");
            }
        }
    }
}

