/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.RequestInjectionConfig;
import com.networknt.handler.RequestInterceptor;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RequestTooBigException;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

public class RequestInterceptorInjectionHandler
implements MiddlewareHandler {
    public static final String GENERIC_EXCEPTION = "ERR10014";
    public static final String PAYLOAD_TOO_LARGE = "ERR10068";
    private static final Logger LOG = LoggerFactory.getLogger(RequestInterceptorInjectionHandler.class);
    private volatile HttpHandler next;
    private static RequestInjectionConfig config;
    private RequestInterceptor[] interceptors = null;

    public RequestInterceptorInjectionHandler() {
        config = RequestInjectionConfig.load();
        LOG.info("RequestInterceptorInjectionHandler is loaded!");
        this.interceptors = SingletonServiceFactory.getBeans(RequestInterceptor.class);
    }

    public RequestInterceptorInjectionHandler(RequestInjectionConfig cfg) {
        config = cfg;
        LOG.info("RequestInterceptorInjectionHandler is loaded!");
        this.interceptors = SingletonServiceFactory.getBeans(RequestInterceptor.class);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void reload() {
        config.reload();
        if (LOG.isTraceEnabled()) {
            LOG.trace("request-injection.yml is reloaded");
        }
        ModuleRegistry.registerModule("request-injection", RequestInterceptorInjectionHandler.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("request-injection"), null);
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("request-injection", RequestInterceptorInjectionHandler.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("request-injection"), null);
    }

    @Override
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        String method = httpServerExchange.getRequestMethod().toString();
        this.next = Handler.getNext(httpServerExchange);
        if (logger.isTraceEnabled()) {
            logger.trace("injectionContentRequired = {} appliedBodyInjectionPathPrefix = {} method = {} requestComplete = {} requiresContinueResponse = {}", this.injectorContentRequired(), this.isAppliedBodyInjectionPathPrefix(httpServerExchange.getRequestPath()), method, httpServerExchange.isRequestComplete(), HttpContinue.requiresContinueResponse(httpServerExchange.getRequestHeaders()));
        }
        if (this.shouldReadBody(httpServerExchange)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Trying to read body");
            }
            StreamSourceChannel channel = httpServerExchange.getRequestChannel();
            PooledByteBuffer[] bufferedData = new PooledByteBuffer[config.getMaxBuffers()];
            int readBuffers = 0;
            PooledByteBuffer buffer = httpServerExchange.getConnection().getByteBufferPool().allocate();
            try {
                while (true) {
                    ByteBuffer b;
                    int r;
                    if ((r = channel.read(b = buffer.getBuffer())) == -1) {
                        RequestInterceptorInjectionHandler.handleEndOfStream(b, bufferedData, readBuffers, buffer);
                        break;
                    }
                    if (r == 0) {
                        this.setChannelRead(channel, buffer, readBuffers, bufferedData, httpServerExchange);
                        channel.resumeReads();
                        return;
                    }
                    if (b.hasRemaining()) continue;
                    b.flip();
                    bufferedData[readBuffers++] = buffer;
                    if (readBuffers == config.getMaxBuffers()) break;
                    buffer = httpServerExchange.getConnection().getByteBufferPool().allocate();
                }
                this.saveBufferAndResetUndertowConnector(httpServerExchange, bufferedData);
            }
            catch (RequestTooBigException e) {
                logger.error(e.getMessage(), e);
                RequestInterceptorInjectionHandler.safeCloseBuffers(bufferedData, buffer);
                this.setExchangeStatus(httpServerExchange, PAYLOAD_TOO_LARGE, new Object[0]);
                return;
            }
            catch (Error | Exception e) {
                logger.error(e.getMessage(), e);
                RequestInterceptorInjectionHandler.safeCloseBuffers(bufferedData, buffer);
                this.setExchangeStatus(httpServerExchange, GENERIC_EXCEPTION, e.getMessage());
                return;
            }
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("No need to read body");
            }
            this.invokeInterceptors(httpServerExchange);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Exchange response started status = {}", (Object)httpServerExchange.isResponseStarted());
        }
        if (!httpServerExchange.isResponseStarted()) {
            Handler.next(httpServerExchange, this.next);
        }
    }

    private boolean shouldReadBody(HttpServerExchange ex) {
        HeaderMap headers = ex.getRequestHeaders();
        String requestMethod = ex.getRequestMethod().toString();
        String requestPath = ex.getRequestPath();
        return this.injectorContentRequired() && this.isAppliedBodyInjectionPathPrefix(requestPath) && this.hasContent(requestMethod) && !ex.isRequestComplete() && !HttpContinue.requiresContinueResponse(headers);
    }

    private boolean hasContent(String method) {
        return method.equalsIgnoreCase("post") || method.equalsIgnoreCase("put") || method.equalsIgnoreCase("patch");
    }

    private boolean injectorContentRequired() {
        return this.interceptors != null && this.interceptors.length > 0 && Arrays.stream(this.interceptors).anyMatch(RequestInterceptor::isRequiredContent);
    }

    private void setChannelRead(StreamSourceChannel c, final PooledByteBuffer cPooledBuffer, final int cRead, final PooledByteBuffer[] bufferedData, final HttpServerExchange ex) {
        c.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){
            PooledByteBuffer buffer;
            int readBuffers;
            {
                this.buffer = cPooledBuffer;
                this.readBuffers = cRead;
            }

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                try {
                    while (true) {
                        ByteBuffer b;
                        int r;
                        if ((r = channel.read(b = this.buffer.getBuffer())) == -1) {
                            RequestInterceptorInjectionHandler.handleEndOfStream(b, bufferedData, this.readBuffers, this.buffer);
                            RequestInterceptorInjectionHandler.this.suspendReads(ex, bufferedData, channel, RequestInterceptorInjectionHandler.this.next);
                            return;
                        }
                        if (r == 0) {
                            return;
                        }
                        if (b.hasRemaining()) continue;
                        b.flip();
                        bufferedData[this.readBuffers++] = this.buffer;
                        if (this.readBuffers == config.getMaxBuffers()) {
                            RequestInterceptorInjectionHandler.this.suspendReads(ex, bufferedData, channel, RequestInterceptorInjectionHandler.this.next);
                            return;
                        }
                        this.buffer = ex.getConnection().getByteBufferPool().allocate();
                    }
                }
                catch (Throwable e) {
                    RequestInterceptorInjectionHandler.safeCloseBuffers(bufferedData, this.buffer);
                    ex.endExchange();
                    return;
                }
            }
        });
    }

    private static void safeCloseBuffers(PooledByteBuffer[] buffers, PooledByteBuffer buf) {
        for (PooledByteBuffer b : buffers) {
            IoUtils.safeClose((Closeable)b);
        }
        if (buf != null && buf.isOpen()) {
            IoUtils.safeClose((Closeable)buf);
        }
    }

    private void suspendReads(HttpServerExchange ex, PooledByteBuffer[] bufferedData, StreamSourceChannel c, HttpHandler next) {
        this.saveBufferAndResetUndertowConnector(ex, bufferedData);
        c.getReadSetter().set(null);
        c.suspendReads();
        if (LOG.isTraceEnabled()) {
            LOG.info("Next is: {}", (Object)next.getClass());
        }
        Connectors.executeRootHandler(next, ex);
    }

    private void saveBufferAndResetUndertowConnector(HttpServerExchange ex, PooledByteBuffer[] bufferedData) {
        if (logger.isTraceEnabled()) {
            logger.trace("saveBufferAndResetUndertowConnector is called.");
        }
        ex.putAttachment(AttachmentConstants.BUFFERED_REQUEST_DATA_KEY, bufferedData);
        this.updateContentLength(ex, bufferedData);
        Connectors.ungetRequestBytes(ex, bufferedData);
        Connectors.resetRequestChannel(ex);
        this.invokeInterceptors(ex);
    }

    private void updateContentLength(HttpServerExchange ex, PooledByteBuffer[] bufferedData) {
        if (ex.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH) != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("original content length in request headers = {}", (Object)ex.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH));
            }
            long length = 0L;
            for (PooledByteBuffer dest : bufferedData) {
                if (dest == null) continue;
                length += (long)dest.getBuffer().limit();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("update content length in request headers = {}", (Object)length);
            }
            ex.getRequestHeaders().put(Headers.CONTENT_LENGTH, length);
        }
    }

    private static void handleEndOfStream(ByteBuffer b, PooledByteBuffer[] bufferedData, int readBuffers, PooledByteBuffer buffer) {
        if (b.position() == 0) {
            buffer.close();
        } else {
            b.flip();
            bufferedData[readBuffers] = buffer;
        }
    }

    private void invokeInterceptors(HttpServerExchange httpServerExchange) {
        if (this.interceptors != null && this.interceptors.length > 0) {
            for (RequestInterceptor ri : this.interceptors) {
                try {
                    ri.handleRequest(httpServerExchange);
                    if (!httpServerExchange.isResponseStarted()) continue;
                    return;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                    return;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAppliedBodyInjectionPathPrefix(String requestPath) {
        if (config.getAppliedBodyInjectionPathPrefixes() == null) return false;
        if (!config.getAppliedBodyInjectionPathPrefixes().stream().anyMatch(requestPath::startsWith)) return false;
        return true;
    }
}

