/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.config.Config;
import com.networknt.handler.HandlerProvider;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.config.EndpointSource;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.handler.config.PathChain;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.PathTemplateMatcher;
import com.networknt.utility.Tuple;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HttpString;
import io.undertow.util.PathTemplateMatch;
import io.undertow.websockets.WebSocketConnectionCallback;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Handler {
    private static final AttachmentKey<Integer> CHAIN_SEQ = AttachmentKey.create(Integer.class);
    private static final AttachmentKey<String> CHAIN_ID = AttachmentKey.create(String.class);
    private static final AttachmentKey<HandlerMetricsCollector> EXECUTION_METRIC = AttachmentKey.create(HandlerMetricsCollector.class);
    private static final AttachmentKey<String> METRICS_REPORT = AttachmentKey.create(String.class);
    private static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    public static HandlerConfig config = HandlerConfig.load();
    static final Map<String, HttpHandler> handlers = new HashMap<String, HttpHandler>();
    static final Map<String, List<HttpHandler>> handlerListById = new HashMap<String, List<HttpHandler>>();
    static final Map<HttpString, PathTemplateMatcher<String>> methodToMatcherMap = new HashMap<HttpString, PathTemplateMatcher<String>>();
    static List<HttpHandler> defaultHandlers;
    static HttpHandler lastHandler;

    public static void setLastHandler(HttpHandler handler) {
        lastHandler = handler;
    }

    public static void init() {
        Handler.initHandlers();
        Handler.initChains();
        Handler.initPaths();
        Handler.initDefaultHandlers();
        ModuleRegistry.registerModule("handler", Handler.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("handler"), null);
    }

    static void initHandlers() {
        if (config != null && config.getHandlers() != null) {
            for (String handler : config.getHandlers()) {
                Handler.initStringDefinedHandler(handler);
            }
        }
    }

    static void initChains() {
        if (config != null && config.getChains() != null) {
            for (String chainName : config.getChains().keySet()) {
                List<String> chain = config.getChains().get(chainName);
                ArrayList<HttpHandler> handlerChain = new ArrayList<HttpHandler>();
                for (String chainItemName : chain) {
                    HttpHandler chainItem = handlers.get(chainItemName);
                    if (chainItem == null) {
                        throw new RuntimeException("Chain " + chainName + " uses Unknown handler: " + chainItemName);
                    }
                    handlerChain.add(chainItem);
                }
                handlerListById.put(chainName, handlerChain);
            }
        }
    }

    static void initPaths() {
        if (config != null && config.getPaths() != null) {
            for (PathChain pathChain : config.getPaths()) {
                pathChain.validate("handler config");
                if (pathChain.getPath() == null) {
                    Handler.addSourceChain(pathChain);
                    continue;
                }
                Handler.addPathChain(pathChain);
            }
        }
    }

    static void initDefaultHandlers() {
        if (config != null && config.getDefaultHandlers() != null) {
            defaultHandlers = Handler.getHandlersFromExecList(config.getDefaultHandlers());
            handlerListById.put("defaultHandlers", defaultHandlers);
        }
    }

    private static void addSourceChain(PathChain sourceChain) {
        try {
            Class<?> sourceClass = Class.forName(sourceChain.getSource());
            EndpointSource source2 = (EndpointSource)sourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (EndpointSource.Endpoint endpoint : source2.listEndpoints()) {
                PathChain sourcedPath = new PathChain();
                sourcedPath.setPath(endpoint.getPath());
                sourcedPath.setMethod(endpoint.getMethod());
                sourcedPath.setExec(sourceChain.getExec());
                sourcedPath.validate(sourceChain.getSource());
                Handler.addPathChain(sourcedPath);
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed to inject handler.yml paths from: {}", (Object)sourceChain);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void addPathChain(PathChain pathChain) {
        HttpString method = new HttpString(pathChain.getMethod());
        int randInt = new Random().nextInt();
        while (handlerListById.containsKey(Integer.toString(randInt))) {
            randInt = new Random().nextInt();
        }
        List<HttpHandler> handlers = Handler.getHandlersFromExecList(pathChain.getExec());
        if (!handlers.isEmpty()) {
            PathTemplateMatcher<Object> pathTemplateMatcher;
            PathTemplateMatcher<Object> pathTemplateMatcher2 = pathTemplateMatcher = methodToMatcherMap.containsKey(method) ? methodToMatcherMap.get(method) : new PathTemplateMatcher();
            if (pathTemplateMatcher.get(pathChain.getPath()) == null) {
                pathTemplateMatcher.add(pathChain.getPath(), (Object)Integer.toString(randInt));
            }
            methodToMatcherMap.put(method, pathTemplateMatcher);
            handlerListById.put(Integer.toString(randInt), handlers);
        }
    }

    public static void next(HttpServerExchange httpServerExchange) throws Exception {
        HandlerMetricsCollector metrics;
        HttpHandler httpHandler = Handler.getNext(httpServerExchange);
        if (config.isEnabledHandlerMetrics()) {
            metrics = httpServerExchange.getAttachment(EXECUTION_METRIC);
            String handlerName = httpHandler != null ? httpHandler.toString() : (lastHandler != null ? lastHandler.toString() : "unknown");
            metrics.initNextHandlerMeasurement(handlerName);
        }
        if (httpHandler != null) {
            httpHandler.handleRequest(httpServerExchange);
        } else if (lastHandler != null) {
            lastHandler.handleRequest(httpServerExchange);
        }
        if (config.isEnabledHandlerMetrics()) {
            metrics = httpServerExchange.getAttachment(EXECUTION_METRIC);
            String report = metrics.finalizeHandlerMetrics();
            httpServerExchange.putAttachment(METRICS_REPORT, report);
        }
    }

    public static void next(HttpServerExchange httpServerExchange, HttpHandler next) throws Exception {
        if (next != null) {
            next.handleRequest(httpServerExchange);
        } else {
            Handler.next(httpServerExchange);
        }
    }

    public static void next(HttpServerExchange ex, String execName, Boolean returnToOrigFlow) throws Exception {
        String currentChainId = ex.getAttachment(CHAIN_ID);
        Integer currentNextIndex = ex.getAttachment(CHAIN_SEQ);
        ex.putAttachment(CHAIN_ID, execName);
        ex.putAttachment(CHAIN_SEQ, 0);
        Handler.next(ex);
        if (returnToOrigFlow.booleanValue()) {
            ex.putAttachment(CHAIN_ID, currentChainId);
            ex.putAttachment(CHAIN_SEQ, currentNextIndex);
            Handler.next(ex);
        }
    }

    public static HttpHandler getNext(HttpServerExchange httpServerExchange) {
        String chainId = httpServerExchange.getAttachment(CHAIN_ID);
        List<HttpHandler> handlersForId = handlerListById.get(chainId);
        Integer nextIndex = httpServerExchange.getAttachment(CHAIN_SEQ);
        if (nextIndex < handlersForId.size()) {
            httpServerExchange.putAttachment(CHAIN_SEQ, nextIndex + 1);
            return handlersForId.get(nextIndex);
        }
        return null;
    }

    public static HttpHandler getNext(HttpServerExchange httpServerExchange, HttpHandler next) throws Exception {
        if (next != null) {
            return next;
        }
        return Handler.getNext(httpServerExchange);
    }

    public static boolean start(HttpServerExchange ex) {
        PathTemplateMatcher.PathMatchResult<String> result2;
        PathTemplateMatcher<String> pathTemplateMatcher = methodToMatcherMap.get(ex.getRequestMethod());
        if (pathTemplateMatcher != null && (result2 = pathTemplateMatcher.match(ex.getRequestPath())) != null) {
            if (config.isEnabledHandlerMetrics()) {
                ex.putAttachment(EXECUTION_METRIC, new HandlerMetricsCollector());
            }
            ex.putAttachment(PathTemplateMatch.ATTACHMENT_KEY, new PathTemplateMatch(result2.getMatchedTemplate(), result2.getParameters()));
            for (Map.Entry<String, String> entry : result2.getParameters().entrySet()) {
                ex.addQueryParam(entry.getKey(), entry.getValue());
                ex.addPathParam(entry.getKey(), entry.getValue());
            }
            String id = result2.getValue();
            ex.putAttachment(CHAIN_ID, id);
            ex.putAttachment(CHAIN_SEQ, 0);
            return true;
        }
        return false;
    }

    public static boolean startDefaultHandlers(HttpServerExchange ex) {
        if (defaultHandlers != null && defaultHandlers.size() > 0) {
            ex.putAttachment(CHAIN_ID, "defaultHandlers");
            ex.putAttachment(CHAIN_SEQ, 0);
            return true;
        }
        return false;
    }

    private static List<HttpHandler> getHandlersFromExecList(List<String> execs) {
        ArrayList<HttpHandler> handlersFromExecList = new ArrayList<HttpHandler>();
        if (execs != null) {
            for (String exec : execs) {
                List<HttpHandler> handlerList = handlerListById.get(exec);
                if (handlerList == null) {
                    throw new RuntimeException("Unknown handler or chain: " + exec);
                }
                for (HttpHandler handler : handlerList) {
                    if (handler instanceof MiddlewareHandler) {
                        if (!((MiddlewareHandler)handler).isEnabled()) continue;
                        handlersFromExecList.add(handler);
                        continue;
                    }
                    handlersFromExecList.add(handler);
                }
            }
        }
        return handlersFromExecList;
    }

    private static void registerMiddlewareHandler(Object handler) {
        if (handler instanceof MiddlewareHandler && ((MiddlewareHandler)handler).isEnabled()) {
            ((MiddlewareHandler)handler).register();
        }
    }

    private static void initStringDefinedHandler(String handler) {
        HttpHandler resolvedHandler;
        Tuple<String, Class> namedClass = Handler.splitClassAndName(handler);
        Object handlerOrProviderObject = null;
        try {
            handlerOrProviderObject = ((Class)namedClass.second).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Could not instantiate handler class " + String.valueOf(namedClass.second), e);
            throw new RuntimeException("Could not instantiate handler class: " + String.valueOf(namedClass.second));
        }
        if (handlerOrProviderObject instanceof HttpHandler) {
            resolvedHandler = handlerOrProviderObject;
        } else if (handlerOrProviderObject instanceof HandlerProvider) {
            resolvedHandler = ((HandlerProvider)handlerOrProviderObject).getHandler();
        } else if (handlerOrProviderObject instanceof WebSocketConnectionCallback) {
            resolvedHandler = Handlers.websocket(handlerOrProviderObject);
        } else {
            throw new RuntimeException("Unsupported type of handler provided: " + String.valueOf(handlerOrProviderObject));
        }
        Handler.registerMiddlewareHandler(resolvedHandler);
        handlers.put((String)namedClass.first, resolvedHandler);
        handlerListById.put((String)namedClass.first, Collections.singletonList(resolvedHandler));
    }

    static Tuple<String, Class> splitClassAndName(String classLabel) {
        String[] stringNameSplit = classLabel.split("@");
        if (stringNameSplit.length == 1) {
            try {
                return new Tuple<String, Class>(classLabel, Class.forName(classLabel));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Configured class: " + classLabel + " has not been found");
            }
        }
        if (stringNameSplit.length > 1) {
            try {
                return new Tuple<String, Class>(stringNameSplit[1], Class.forName(stringNameSplit[0]));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Configured class: " + stringNameSplit[0] + " has not been found. Declared label was: " + stringNameSplit[1]);
            }
        }
        throw new RuntimeException("Invalid format provided for class label: " + classLabel);
    }

    static void setConfig(String configName) throws Exception {
        config = HandlerConfig.load(configName);
        Handler.initHandlers();
        Handler.initChains();
        Handler.initPaths();
    }

    public static Map<String, HttpHandler> getHandlers() {
        return handlers;
    }

    protected static class HandlerMetricsCollector {
        private boolean completed = false;
        private final ArrayList<StopWatch> metrics = new ArrayList();

        protected HandlerMetricsCollector() {
        }

        public void initNextHandlerMeasurement(String handlerName) {
            this.stopPreviousHandler();
            StopWatch nextHandler = new StopWatch(handlerName);
            nextHandler.start();
            this.metrics.add(nextHandler);
        }

        private void stopPreviousHandler() {
            if (!this.metrics.isEmpty()) {
                StopWatch previousHandler = this.metrics.get(this.metrics.size() - 1);
                previousHandler.stop();
            }
        }

        public String finalizeHandlerMetrics() {
            if (this.completed) {
                throw new IllegalStateException("Metrics already finalized.");
            }
            this.completed = true;
            this.stopPreviousHandler();
            String report = this.buildMetricsReport();
            LOG.atLevel(Level.valueOf(config.getHandlerMetricsLogLevel())).log(report);
            return report;
        }

        private String buildMetricsReport() {
            StringBuilder metricsDisplay = new StringBuilder();
            metricsDisplay.append("[");
            int x = 1;
            while (!this.metrics.isEmpty()) {
                StopWatch currentHandler = this.metrics.remove(0);
                if (currentHandler.isRunning()) {
                    throw new IllegalStateException("Handler metric stop watch is still running!");
                }
                metricsDisplay.append("{").append("\"num\": ").append(x).append(", ");
                metricsDisplay.append("\"name\": ").append("\"").append(currentHandler.getName()).append("\", ");
                metricsDisplay.append("\"duration\": ").append(currentHandler.getDuration()).append("}");
                if (!this.metrics.isEmpty()) {
                    metricsDisplay.append(", ");
                }
                ++x;
            }
            metricsDisplay.append("]");
            return metricsDisplay.toString();
        }
    }

    private static class StopWatch {
        private long startTime;
        private long endTime;
        private boolean running = false;
        private final String name;

        public StopWatch(String name2) {
            this.name = name2;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void start() {
            if (this.running) {
                throw new IllegalStateException("Cannot start twice!");
            }
            this.startTime = System.currentTimeMillis();
            this.running = true;
        }

        public void stop() {
            if (!this.running) {
                throw new IllegalStateException("Cannot end twice!");
            }
            this.running = false;
            this.endTime = System.currentTimeMillis();
        }

        public String getName() {
            return this.name;
        }

        public long getDuration() {
            if (this.running) {
                throw new IllegalStateException("Watch must be stopped first.");
            }
            return this.endTime - this.startTime;
        }
    }
}

