/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.config.Config;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="consul", configName="consul", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class ConsulConfig {
    public static final String CONFIG_NAME = "consul";
    private static final Logger logger = LoggerFactory.getLogger(ConsulConfig.class);
    private static final String CONSUL_URL = "consulUrl";
    private static final String DEREGISTER_AFTER = "deregisterAfter";
    private static final String CONSUL_TOKEN = "consulToken";
    private static final String MAX_REQ_PER_CONN = "maxReqPerConn";
    private static final String CHECK_INTERVAL = "checkInterval";
    private static final String TCP_CHECK = "tcpCheck";
    private static final String HTTP_CHECK = "httpCheck";
    private static final String TTL_CHECK = "ttlCheck";
    private static final String WAIT = "wait";
    private static final String TIMEOUT_BUFFER = "timeoutBuffer";
    private static final String ENABLE_HTTP2 = "enableHttp2";
    private static final String CONNECTION_TIMEOUT = "connectionTimeout";
    private static final String REQUEST_TIMEOUT = "requestTimeout";
    private static final String RECONNECT_INTERVAL = "reconnectInterval";
    private static final String RECONNECT_JITTER = "reconnectJitter";
    private static final String LOOKUP_INTERVAL = "lookupInterval";
    private static final String MAX_ATTEMPTS_BEFORE_SHUTDOWN = "maxAttemptsBeforeShutdown";
    private static final String SHUTDOWN_IF_THREAD_FROZEN = "shutdownIfThreadFrozen";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    @StringField(configFieldName="consulUrl", externalizedKeyName="consulUrl", externalized=true, description="Consul URL for accessing APIs")
    String consulUrl;
    @StringField(configFieldName="consulToken", externalizedKeyName="consulToken", defaultValue="the_one_ring", externalized=true, description="access token to the consul server")
    String consulToken;
    @IntegerField(configFieldName="maxReqPerConn", externalizedKeyName="maxReqPerConn", defaultValue=1000000, externalized=true, description="number of requests before reset the shared connection.")
    int maxReqPerConn;
    @StringField(configFieldName="deregisterAfter", externalizedKeyName="deregisterAfter", pattern="^\\d+[smh]$", defaultValue="2m", externalized=true, description="deregister the service after the amount of time after health check failed.")
    String deregisterAfter;
    @StringField(configFieldName="checkInterval", externalizedKeyName="checkInterval", pattern="^\\d+[smh]$", defaultValue="10s", externalized=true, description="health check interval for TCP or HTTP check. Or it will be the TTL for TTL check. Every 10 seconds,\nTCP or HTTP check request will be sent. Or if there is no heart beat request from service after 10 seconds,\nthen mark the service is critical.")
    String checkInterval;
    @BooleanField(configFieldName="tcpCheck", externalizedKeyName="tcpCheck", externalized=true, description="One of the following health check approach will be selected. Two passive (TCP and HTTP) and one active (TTL)\nenable health check TCP. Ping the IP/port to ensure that the service is up. This should be used for most of\nthe services with simple dependencies. If the port is open on the address, it indicates that the service is up.")
    boolean tcpCheck;
    @BooleanField(configFieldName="httpCheck", externalizedKeyName="httpCheck", externalized=true, description="enable health check HTTP. A http get request will be sent to the service to ensure that 200 response status is\ncoming back. This is suitable for service that depending on database or other infrastructure services. You should\nimplement a customized health check handler that checks dependencies. i.e. if db is down, return status 400.")
    boolean httpCheck;
    @BooleanField(configFieldName="ttlCheck", externalizedKeyName="ttlCheck", externalized=true, description="enable health check TTL. When this is enabled, Consul won't actively check your service to ensure it is healthy,\nbut your service will call check endpoint with heart beat to indicate it is alive. This requires that the service\nis built on top of light-4j and the above options are not available. For example, your service is behind NAT.")
    boolean ttlCheck;
    @BooleanField(configFieldName="enableHttp2", externalizedKeyName="enableHttp2", externalized=true, description="enable HTTP/2\nmust disable when using HTTP with Consul (mostly using local Consul agent), Consul only supports HTTP/1.1 when not using TLS\noptional to enable when using HTTPS with Consul, it will have better performance")
    boolean enableHttp2;
    @StringField(configFieldName="wait", externalizedKeyName="wait", defaultValue="600s", pattern="^\\d+[smh]$", externalized=true, description="endpoints that support blocking will also honor a wait parameter specifying a maximum duration for the blocking request.\nThis is limited to 10 minutes.This value can be specified in the form of \"10s\" or \"5m\" (i.e., 10 seconds or 5 minutes,\nrespectively).")
    String wait = "600s";
    @StringField(configFieldName="timeoutBuffer", externalizedKeyName="timeoutBuffer", defaultValue="5s", pattern="^\\d+[smh]$", externalized=true, description="Additional buffer of time to allow Consul to terminate the blocking query connection.")
    String timeoutBuffer = "5s";
    @IntegerField(configFieldName="connectionTimeout", externalizedKeyName="connectionTimeout", defaultValue=5, externalized=true, description="Consul connection establishment timeout in seconds")
    int connectionTimeout = 5;
    @IntegerField(configFieldName="requestTimeout", externalizedKeyName="requestTimeout", defaultValue=5, externalized=true, description="Consul request completion timeout in seconds\nThis does NOT apply to Consul service discovery lookups (see the 'wait' and 'timeoutBuffer' properties for that)")
    int requestTimeout = 5;
    @IntegerField(configFieldName="reconnectInterval", externalizedKeyName="reconnectInterval", defaultValue=2, externalized=true, description="Time to wait in seconds between reconnect attempts when Consul connection fails")
    int reconnectInterval = 2;
    @IntegerField(configFieldName="reconnectJitter", externalizedKeyName="reconnectJitter", defaultValue=2, externalized=true, description="A random number of seconds in between 0 and reconnectJitter added to reconnectInterval (to avoid too many reconnect\nrequests at one time)")
    int reconnectJitter = 2;
    @IntegerField(configFieldName="lookupInterval", externalizedKeyName="lookupInterval", defaultValue=30, externalized=true, description="Time in seconds between blocking queries with Consul. Consul blocking queries time should be set via the\n'lookupInterval' parameter in consul.yml, instead of 'registrySessionTimeout' in service.yml")
    int lookupInterval = 30;
    @IntegerField(configFieldName="maxAttemptsBeforeShutdown", externalizedKeyName="maxAttemptsBeforeShutdown", defaultValue=-1, externalized=true, description="Max number of failed Consul connection or request attempts before self-termination\n-1 means an infinite # of attempts are allowed")
    int maxAttemptsBeforeShutdown = -1;
    @BooleanField(configFieldName="shutdownIfThreadFrozen", externalizedKeyName="shutdownIfThreadFrozen", externalized=true, description="Shuts down host application if any Consul lookup thread stops reporting a heartbeat for\n2 * ( lookupInterval + wait (in seconds) + timeoutBuffer (in seconds) ) seconds")
    boolean shutdownIfThreadFrozen = false;

    private ConsulConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private ConsulConfig() {
        this(CONFIG_NAME);
    }

    public static ConsulConfig load(String configName) {
        return new ConsulConfig(configName);
    }

    public static ConsulConfig load() {
        return new ConsulConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public String getConsulUrl() {
        return this.consulUrl;
    }

    public void setConsulUrl(String consulUrl) {
        this.consulUrl = consulUrl;
    }

    public String getConsulToken() {
        return this.consulToken;
    }

    public void setConsulToken(String consulToken) {
        this.consulToken = consulToken;
    }

    public int getMaxReqPerConn() {
        return this.maxReqPerConn;
    }

    public void setMaxReqPerConn(int maxReqPerConn) {
        this.maxReqPerConn = maxReqPerConn;
    }

    public String getDeregisterAfter() {
        return this.deregisterAfter;
    }

    public void setDeregisterAfter(String deregisterAfter) {
        this.deregisterAfter = deregisterAfter;
    }

    public String getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(String checkInterval) {
        this.checkInterval = checkInterval;
    }

    public boolean isTcpCheck() {
        return this.tcpCheck;
    }

    public void setTcpCheck(boolean tcpCheck) {
        this.tcpCheck = tcpCheck;
    }

    public boolean isHttpCheck() {
        return this.httpCheck;
    }

    public void setHttpCheck(boolean httpCheck) {
        this.httpCheck = httpCheck;
    }

    public boolean isTtlCheck() {
        return this.ttlCheck;
    }

    public void setTtlCheck(boolean ttlCheck) {
        this.ttlCheck = ttlCheck;
    }

    public String getWait() {
        return this.wait;
    }

    public void setWait(String wait) {
        this.wait = wait;
    }

    public String getTimeoutBuffer() {
        return this.timeoutBuffer;
    }

    public void setTimeoutBuffer(String timeoutBuffer) {
        this.timeoutBuffer = timeoutBuffer;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void setEnableHttp2(boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public long getReconnectJitter() {
        return this.reconnectJitter;
    }

    public long getLookupInterval() {
        return this.lookupInterval;
    }

    public long getMaxAttemptsBeforeShutdown() {
        return this.maxAttemptsBeforeShutdown;
    }

    public boolean isShutdownIfThreadFrozen() {
        return this.shutdownIfThreadFrozen;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(CONSUL_URL);
        if (object != null) {
            this.consulUrl = (String)object;
        }
        if ((object = this.mappedConfig.get(CONSUL_TOKEN)) != null) {
            this.consulToken = (String)object;
        }
        if ((object = this.mappedConfig.get(MAX_REQ_PER_CONN)) != null) {
            this.maxReqPerConn = Config.loadIntegerValue(MAX_REQ_PER_CONN, object);
        }
        if ((object = this.mappedConfig.get(CHECK_INTERVAL)) != null) {
            this.checkInterval = (String)object;
        }
        if ((object = this.mappedConfig.get(TCP_CHECK)) != null) {
            this.tcpCheck = Config.loadBooleanValue(TCP_CHECK, object);
        }
        if ((object = this.mappedConfig.get(HTTP_CHECK)) != null) {
            this.httpCheck = Config.loadBooleanValue(HTTP_CHECK, object);
        }
        if ((object = this.mappedConfig.get(TTL_CHECK)) != null) {
            this.ttlCheck = Config.loadBooleanValue(TTL_CHECK, object);
        }
        if ((object = this.mappedConfig.get(WAIT)) != null) {
            this.wait = (String)object;
        }
        if ((object = this.mappedConfig.get(TIMEOUT_BUFFER)) != null) {
            this.timeoutBuffer = (String)object;
        }
        if ((object = this.mappedConfig.get(ENABLE_HTTP2)) != null) {
            this.enableHttp2 = Config.loadBooleanValue(ENABLE_HTTP2, object);
        }
        if ((object = this.mappedConfig.get(CONNECTION_TIMEOUT)) != null) {
            this.connectionTimeout = Config.loadIntegerValue(CONNECTION_TIMEOUT, object);
        }
        if ((object = this.mappedConfig.get(REQUEST_TIMEOUT)) != null) {
            this.requestTimeout = Config.loadIntegerValue(REQUEST_TIMEOUT, object);
        }
        if ((object = this.mappedConfig.get(RECONNECT_INTERVAL)) != null) {
            this.reconnectInterval = Config.loadIntegerValue(RECONNECT_INTERVAL, object);
        }
        if ((object = this.mappedConfig.get(RECONNECT_JITTER)) != null) {
            this.reconnectJitter = Config.loadIntegerValue(RECONNECT_JITTER, object);
        }
        if ((object = this.mappedConfig.get(LOOKUP_INTERVAL)) != null) {
            this.lookupInterval = Config.loadIntegerValue(LOOKUP_INTERVAL, object);
        }
        if ((object = this.mappedConfig.get(MAX_ATTEMPTS_BEFORE_SHUTDOWN)) != null) {
            this.maxAttemptsBeforeShutdown = Config.loadIntegerValue(MAX_ATTEMPTS_BEFORE_SHUTDOWN, object);
        }
        if ((object = this.mappedConfig.get(SHUTDOWN_IF_THREAD_FROZEN)) != null) {
            this.shutdownIfThreadFrozen = Config.loadBooleanValue(SHUTDOWN_IF_THREAD_FROZEN, object);
        }
    }
}

