/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config.schema.generator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.config.schema.AnnotationUtils;
import com.networknt.config.schema.Format;
import com.networknt.config.schema.generator.Generator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.tools.FileObject;

public class JsonSchemaGenerator
extends Generator {
    private static final String JSON_DRAFT = "http://json-schema.org/draft-07/schema#";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final DefaultPrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    private static final DefaultIndenter DEFAULT_INDENTER = new DefaultIndenter();

    public JsonSchemaGenerator(String configKey, String configName) {
        super(configKey, configName);
    }

    @Override
    public void writeSchemaToFile(OutputStream os, LinkedHashMap<String, Object> metadata) throws IOException {
        LinkedHashMap<String, Object> schemaMap = this.prepJsonMetadataObject(metadata);
        OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(os, schemaMap);
    }

    @Override
    public void writeSchemaToFile(FileObject source2, LinkedHashMap<String, Object> metadata) throws IOException {
        LinkedHashMap<String, Object> schemaMap = this.prepJsonMetadataObject(metadata);
        OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(source2.openOutputStream(), schemaMap);
    }

    @Override
    public void writeSchemaToFile(Writer br, LinkedHashMap<String, Object> metadata) throws IOException {
        LinkedHashMap<String, Object> schemaMap = this.prepJsonMetadataObject(metadata);
        OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(br, schemaMap);
    }

    private LinkedHashMap<String, Object> prepJsonMetadataObject(LinkedHashMap<String, Object> metadata) {
        LinkedHashMap<String, Object> schemaMap = new LinkedHashMap<String, Object>();
        schemaMap.put("$schema", JSON_DRAFT);
        schemaMap.put("type", "object");
        if (Generator.fieldIsSubMap(metadata, "properties")) {
            schemaMap.put("required", ((LinkedHashMap)metadata.get("properties")).keySet().toArray());
            schemaMap.put("properties", this.getRootSchemaProperties(metadata));
        } else {
            schemaMap.put("additionalProperties", true);
        }
        return schemaMap;
    }

    @Override
    protected LinkedHashMap<String, Object> getRootSchemaProperties(LinkedHashMap<String, Object> metadata) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        LinkedHashMap metadataProperties = (LinkedHashMap)metadata.get("properties");
        metadataProperties.forEach((key, value) -> {
            LinkedHashMap<String, Object> property = new LinkedHashMap<String, Object>();
            this.parseField((LinkedHashMap)value, property);
            if (metadata.containsKey("configFieldName") && !((String)metadata.get("configFieldName")).isEmpty()) {
                properties.put((String)metadata.get("configFieldName"), property);
            } else {
                properties.put((String)key, property);
            }
        });
        return properties;
    }

    @Override
    protected void parseString(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        property.put("type", "string");
        AnnotationUtils.updateIfNotDefault(field, property, "description", "", String.class);
        String presentValue = AnnotationUtils.getAsType(field.get("defaultValue"), String.class);
        if (presentValue != null && !Objects.equals(presentValue, "")) {
            property.put("default", presentValue);
        }
        AnnotationUtils.updateIfNotDefault(field, property, "minLength", 0, Integer.class);
        AnnotationUtils.updateIfNotDefault(field, property, "maxLength", Integer.MAX_VALUE, Integer.class);
        AnnotationUtils.updateIfNotDefault(field, property, "pattern", "", String.class);
        AnnotationUtils.updateIfNotDefault(field, property, "format", Format.none.toString(), String.class);
    }

    @Override
    protected void parseInteger(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        property.put("type", "integer");
        AnnotationUtils.updateIfNotDefault(field, property, "description", "", String.class);
        Integer presentValue = AnnotationUtils.getAsType(field.get("defaultValue"), Integer.class);
        if (presentValue != null && !Objects.equals(presentValue, 0)) {
            property.put("default", presentValue);
        }
        AnnotationUtils.updateIfNotDefault(field, property, "minimum", Integer.MIN_VALUE, Integer.class);
        AnnotationUtils.updateIfNotDefault(field, property, "maximum", Integer.MAX_VALUE, Integer.class);
        AnnotationUtils.updateIfNotDefault(field, property, "exclusiveMin", false, Boolean.class);
        AnnotationUtils.updateIfNotDefault(field, property, "exclusiveMax", false, Boolean.class);
        AnnotationUtils.updateIfNotDefault(field, property, "multipleOf", 0, Integer.class);
        AnnotationUtils.updateIfNotDefault(field, property, "format", Format.int32.toString(), String.class);
    }

    @Override
    protected void parseBoolean(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        property.put("type", "boolean");
        AnnotationUtils.updateIfNotDefault(field, property, "description", "", String.class);
        Boolean presentValue = AnnotationUtils.getAsType(field.get("defaultValue"), Boolean.class);
        if (presentValue != null && !Objects.equals(presentValue, false)) {
            property.put("default", presentValue);
        }
    }

    @Override
    protected void parseMapField(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        property.put("type", "object");
        AnnotationUtils.updateIfNotDefault(field, property, "description", "", String.class);
        LinkedHashMap<String, Object> valueProperties = new LinkedHashMap<String, Object>();
        assert (Generator.fieldIsSubMap(field, "additionalProperties"));
        LinkedHashMap valueMetadata = (LinkedHashMap)field.get("additionalProperties");
        this.parseField(valueMetadata, valueProperties);
        property.put("additionalProperties", valueProperties);
    }

    @Override
    protected void parseNumber(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        property.put("type", "number");
        AnnotationUtils.updateIfNotDefault(field, property, "description", "", String.class);
        Number presentValue = AnnotationUtils.getAsType(field.get("defaultValue"), Number.class);
        if (presentValue != null && !Objects.equals(presentValue, 0.0)) {
            property.put("default", presentValue);
        }
        AnnotationUtils.updateIfNotDefault(field, property, "minimum", Double.MIN_VALUE, Number.class);
        AnnotationUtils.updateIfNotDefault(field, property, "maximum", Double.MAX_VALUE, Number.class);
        AnnotationUtils.updateIfNotDefault(field, property, "exclusiveMin", false, Boolean.class);
        AnnotationUtils.updateIfNotDefault(field, property, "exclusiveMax", false, Boolean.class);
        AnnotationUtils.updateIfNotDefault(field, property, "multipleOf", 0, Integer.class);
        AnnotationUtils.updateIfNotDefault(field, property, "format", Format.float32.toString(), String.class);
    }

    @Override
    protected void parseArray(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        property.put("type", "array");
        AnnotationUtils.updateIfNotDefault(field, property, "description", "", String.class);
        AnnotationUtils.updateIfNotDefault(field, property, "minItems", 0, Integer.class);
        AnnotationUtils.updateIfNotDefault(field, property, "maxItems", Integer.MAX_VALUE, Integer.class);
        AnnotationUtils.updateIfNotDefault(field, property, "uniqueItems", false, Boolean.class);
        String presentValue = AnnotationUtils.getAsType(field.get("defaultValue"), String.class);
        if (presentValue != null && !Objects.equals(presentValue, "")) {
            try {
                property.put("default", OBJECT_MAPPER.readValue(presentValue, Object.class));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        LinkedHashMap<String, Object> arraySubProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap items = (LinkedHashMap)field.get("items");
        this.parseField(items, arraySubProperties);
        property.put("items", arraySubProperties);
    }

    @Override
    protected void parseNullField(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        property.put("type", "null");
        String presentValue = AnnotationUtils.getAsType(field.get("defaultValue"), String.class);
        if (presentValue != null && !Objects.equals(presentValue, "")) {
            property.put("default", presentValue);
        }
    }

    @Override
    protected void parseObject(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        LinkedHashMap objectProperties;
        boolean usesAdditionalProperties = false;
        property.put("type", "object");
        AnnotationUtils.updateIfNotDefault(field, property, "description", "", String.class);
        if (Generator.fieldIsSubMap(field, "ref")) {
            objectProperties = (LinkedHashMap)((LinkedHashMap)field.get("ref")).get("properties");
        } else if (Generator.fieldIsSubMap(field, "additionalProperties")) {
            usesAdditionalProperties = true;
            objectProperties = (LinkedHashMap)((LinkedHashMap)field.get("additionalProperties")).get("properties");
        } else if (Generator.fieldIsSubMap(field, "properties")) {
            objectProperties = (LinkedHashMap)field.get("properties");
        } else {
            throw new IllegalArgumentException("Object field must contain a reference or additional properties.");
        }
        String presentValue = AnnotationUtils.getAsType(field.get("defaultValue"), String.class);
        if (presentValue != null && !Objects.equals(presentValue, "")) {
            try {
                property.put("default", OBJECT_MAPPER.readValue(presentValue, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        HashMap subObjectProperties = new HashMap();
        objectProperties.forEach((key, value) -> {
            LinkedHashMap<String, Object> subProperty = new LinkedHashMap<String, Object>();
            this.parseField((LinkedHashMap)value, subProperty);
            if (subProperty.containsKey("configFieldName") && !((String)subProperty.get("configFieldName")).isEmpty()) {
                subObjectProperties.put((String)subProperty.get("configFieldName"), subProperty);
            } else {
                subObjectProperties.put(key, subProperty);
            }
        });
        if (usesAdditionalProperties) {
            LinkedHashMap<String, Object> wrapperObject = new LinkedHashMap<String, Object>();
            wrapperObject.put("type", "object");
            wrapperObject.put("properties", subObjectProperties);
            property.put("additionalProperties", wrapperObject);
        } else {
            property.put("properties", subObjectProperties);
        }
    }

    static {
        DEFAULT_INDENTER.withLinefeed("\n");
        DEFAULT_PRETTY_PRINTER.withObjectIndenter(DEFAULT_INDENTER);
        DEFAULT_PRETTY_PRINTER.withArrayIndenter(DEFAULT_INDENTER);
        OBJECT_MAPPER.setDefaultPrettyPrinter(DEFAULT_PRETTY_PRINTER);
    }
}

