/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config.schema.generator;

import com.networknt.config.schema.AnnotationUtils;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.generator.DebugGenerator;
import com.networknt.config.schema.generator.JsonSchemaGenerator;
import com.networknt.config.schema.generator.YamlGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedHashMap;
import javax.tools.FileObject;

public abstract class Generator {
    protected final String configKey;
    protected final String configName;

    public Generator(String configKey, String configName) {
        this.configName = configName;
        this.configKey = configKey;
    }

    public abstract void writeSchemaToFile(FileObject var1, LinkedHashMap<String, Object> var2) throws IOException;

    public abstract void writeSchemaToFile(Writer var1, LinkedHashMap<String, Object> var2) throws IOException;

    public abstract void writeSchemaToFile(OutputStream var1, LinkedHashMap<String, Object> var2) throws IOException;

    protected abstract void parseArray(LinkedHashMap<String, Object> var1, LinkedHashMap<String, Object> var2);

    protected abstract void parseBoolean(LinkedHashMap<String, Object> var1, LinkedHashMap<String, Object> var2);

    protected abstract void parseInteger(LinkedHashMap<String, Object> var1, LinkedHashMap<String, Object> var2);

    protected abstract void parseNumber(LinkedHashMap<String, Object> var1, LinkedHashMap<String, Object> var2);

    protected abstract void parseObject(LinkedHashMap<String, Object> var1, LinkedHashMap<String, Object> var2);

    protected abstract void parseString(LinkedHashMap<String, Object> var1, LinkedHashMap<String, Object> var2);

    protected abstract void parseNullField(LinkedHashMap<String, Object> var1, LinkedHashMap<String, Object> var2);

    protected abstract void parseMapField(LinkedHashMap<String, Object> var1, LinkedHashMap<String, Object> var2);

    protected abstract LinkedHashMap<String, Object> getRootSchemaProperties(LinkedHashMap<String, Object> var1);

    public static Generator getGenerator(OutputFormat format, String configKey, String configName) {
        switch (format) {
            case JSON_SCHEMA: {
                return new JsonSchemaGenerator(configKey, configName);
            }
            case YAML: {
                return new YamlGenerator(configKey, configName);
            }
            case DEBUG: {
                return new DebugGenerator(configKey, configName);
            }
        }
        throw new IllegalArgumentException("Unsupported output format: " + String.valueOf((Object)format));
    }

    protected static boolean fieldIsSubMap(LinkedHashMap<String, Object> map, String field) {
        return map.containsKey(field) && map.get(field) instanceof LinkedHashMap;
    }

    protected void parseField(LinkedHashMap<String, Object> field, LinkedHashMap<String, Object> property) {
        String type;
        switch (type = AnnotationUtils.getAsType(field.get("type"), String.class)) {
            case "array": {
                this.parseArray(field, property);
                break;
            }
            case "map": {
                this.parseMapField(field, property);
                break;
            }
            case "boolean": {
                this.parseBoolean(field, property);
                break;
            }
            case "integer": {
                this.parseInteger(field, property);
                break;
            }
            case "number": {
                this.parseNumber(field, property);
                break;
            }
            case "object": {
                this.parseObject(field, property);
                break;
            }
            case "string": {
                this.parseString(field, property);
                break;
            }
            case "null": {
                this.parseNullField(field, property);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + type + " - Metadata: " + String.valueOf(field));
            }
        }
    }
}

