/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config;

import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.yml.DecryptConstructor;
import com.networknt.decrypt.Decryptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigInjection {
    private static final String INJECTION_ORDER = "injection_order";
    private static final String INJECTION_ORDER_CODE = !System.getProperty("injection_order", "").equals("") ? System.getProperty("injection_order", "") : "2";
    public static final String CENTRALIZED_MANAGEMENT = "values";
    private static final String SCALABLE_CONFIG = "config";
    private static final String EXCLUSION_CONFIG_FILE_LIST = "exclusionConfigFileList";
    private static final String ALLOW_DEFAULT_EMPTY = "allowDefaultValueEmpty";
    private static final String CONVERT_ENV_VARS = "convertEnvVars";
    private static final Map<String, Object> exclusionMap = Config.getInstance().getJsonMapConfig("config");
    private static final Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
    private static final String[] trueArray = new String[]{"y", "Y", "yes", "Yes", "YES", "true", "True", "TRUE", "on", "On", "ON"};
    private static final String[] falseArray = new String[]{"n", "N", "no", "No", "NO", "false", "False", "FALSE", "off", "Off", "OFF"};
    private static final Decryptor decryptor = DecryptConstructor.getInstance().getDecryptor();
    public static Map<String, Object> decryptedValueMap = Config.getInstance().getDefaultJsonMapConfigNoCache("values");
    public static Map<String, Object> undecryptedValueMap = Config.getNoneDecryptedInstance().getDefaultJsonMapConfigNoCache("values");

    public static Object getInjectValue(String string, boolean decrypt) {
        Matcher m4 = pattern.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m4.find()) {
            Object value = ConfigInjection.getValue(m4.group(1), decrypt);
            if (!(value instanceof String)) {
                return value;
            }
            String valueStr = (String)value;
            if (valueStr.contains("\\$")) {
                m4.appendReplacement(sb, (String)value);
                continue;
            }
            m4.appendReplacement(sb, Matcher.quoteReplacement((String)value));
        }
        return m4.appendTail(sb).toString();
    }

    public static boolean isExclusionConfigFile(String configName) {
        ArrayList exclusionConfigFileList = exclusionMap == null || exclusionMap.get(EXCLUSION_CONFIG_FILE_LIST) == null ? new ArrayList() : (List)exclusionMap.get(EXCLUSION_CONFIG_FILE_LIST);
        return SCALABLE_CONFIG.equals(configName) || exclusionConfigFileList.contains(configName);
    }

    public static Decryptor getDecryptor() {
        return decryptor;
    }

    static String convertEnvVars(String input) {
        if (input == null) {
            return null;
        }
        if (exclusionMap.get(CONVERT_ENV_VARS) != null && !((Boolean)exclusionMap.get(CONVERT_ENV_VARS)).booleanValue()) {
            return input;
        }
        return input.replaceAll("[^A-Za-z0-9]", "_").toUpperCase();
    }

    public static Object decryptEnvValue(Decryptor decryptor, String envVal) {
        Object decryptedEnvValue = envVal != null && envVal.trim().startsWith("CRYPT") ? ConfigInjection.typeCast(decryptor.decrypt(envVal)) : envVal;
        return decryptedEnvValue;
    }

    private static Object getValue(String content, boolean decrypt) {
        InjectionPattern injectionPattern = ConfigInjection.getInjectionPattern(content);
        Object value = null;
        if (injectionPattern != null) {
            Object fileValue;
            Object envValue;
            boolean containsField = false;
            String envValString = System.getenv(ConfigInjection.convertEnvVars(injectionPattern.getKey()));
            if (decrypt) {
                envValue = ConfigInjection.decryptEnvValue(decryptor, envValString);
                Object object = fileValue = decryptedValueMap != null ? decryptedValueMap.get(injectionPattern.getKey()) : null;
                if (decryptedValueMap != null && decryptedValueMap.containsKey(injectionPattern.getKey()) || System.getenv() != null && System.getenv().containsKey(injectionPattern.getKey())) {
                    containsField = true;
                }
            } else {
                envValue = envValString;
                Object object = fileValue = undecryptedValueMap != null ? undecryptedValueMap.get(injectionPattern.getKey()) : null;
                if (undecryptedValueMap != null && undecryptedValueMap.containsKey(injectionPattern.getKey()) || System.getenv() != null && System.getenv().containsKey(injectionPattern.getKey())) {
                    containsField = true;
                }
            }
            if ((value = INJECTION_ORDER_CODE.equals("2") && envValue != null || INJECTION_ORDER_CODE.equals("1") && fileValue == null ? envValue : fileValue) == null && !containsField && ((value = ConfigInjection.typeCast(injectionPattern.getDefaultValue())) == null || value.equals(""))) {
                String error_text = injectionPattern.getErrorText();
                if (error_text != null && !error_text.isEmpty()) {
                    throw new ConfigException(error_text);
                }
                if (exclusionMap.get(ALLOW_DEFAULT_EMPTY) == null || !((Boolean)exclusionMap.get(ALLOW_DEFAULT_EMPTY)).booleanValue()) {
                    throw new ConfigException("\"${" + content + "}\" appears in config file cannot be expanded");
                }
            }
        }
        return value;
    }

    private static InjectionPattern getInjectionPattern(String contents) {
        if (contents == null || contents.trim().isEmpty()) {
            return null;
        }
        InjectionPattern injectionPattern = new InjectionPattern();
        contents = contents.trim();
        String[] array = contents.split(":", 2);
        array[0] = array[0].trim();
        if (array[0].isEmpty()) {
            return null;
        }
        injectionPattern.setKey(array[0]);
        if (array.length == 2) {
            array[1] = array[1].trim();
            if (array[1].startsWith("?")) {
                injectionPattern.setErrorText(array[1].substring(1));
            } else if (array[1].startsWith("$")) {
                if (array[1].length() == 1) {
                    injectionPattern.setDefaultValue("\\$\\{" + array[0] + "\\}");
                } else {
                    injectionPattern.setDefaultValue("\\" + array[1]);
                }
            } else {
                injectionPattern.setDefaultValue(array[1]);
            }
        }
        return injectionPattern;
    }

    private static Object typeCast(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        for (String trueString : trueArray) {
            if (!trueString.equals(str)) continue;
            return true;
        }
        for (String falseString : falseArray) {
            if (!falseString.equals(str)) continue;
            return false;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e1) {
            try {
                return Double.parseDouble(str);
            }
            catch (Exception e2) {
                return str;
            }
        }
    }

    private static class InjectionPattern {
        private String key;
        private String defaultValue;
        private String errorText;

        private InjectionPattern() {
        }

        public String getErrorText() {
            return this.errorText;
        }

        public void setErrorText(String errorTest) {
            this.errorText = errorTest;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

