/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.networknt.config.CentralizedManagement;
import com.networknt.config.ConfigException;
import com.networknt.config.ConfigInjection;
import com.networknt.config.ConfigLoader;
import com.networknt.config.yml.ConfigLoaderConstructor;
import com.networknt.config.yml.DecryptConstructor;
import com.networknt.config.yml.YmlConstants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public abstract class Config {
    public static final String LIGHT_4J_CONFIG_DIR = "light-4j-config-dir";

    protected Config() {
    }

    public abstract Map<String, Object> getJsonMapConfig(String var1);

    public abstract Map<String, Object> getDefaultJsonMapConfig(String var1);

    public abstract Map<String, Object> getJsonMapConfig(String var1, String var2);

    public abstract Map<String, Object> getDefaultJsonMapConfig(String var1, String var2);

    public abstract Map<String, Object> getJsonMapConfigNoCache(String var1);

    public abstract Map<String, Object> getDefaultJsonMapConfigNoCache(String var1);

    public abstract Map<String, Object> getJsonMapConfigNoCache(String var1, String var2);

    public abstract Map<String, Object> getDefaultJsonMapConfigNoCache(String var1, String var2);

    public abstract Object getJsonObjectConfig(String var1, Class var2);

    public abstract Object getJsonObjectConfigNoCache(String var1, Class var2);

    public abstract Object getDefaultJsonObjectConfig(String var1, Class var2);

    public abstract Object getJsonObjectConfig(String var1, Class var2, String var3);

    public abstract Object getDefaultJsonObjectConfig(String var1, Class var2, String var3);

    public abstract String getStringFromFile(String var1);

    public abstract String getStringFromFile(String var1, String var2);

    public abstract InputStream getInputStreamFromFile(String var1);

    public abstract ObjectMapper getMapper();

    public abstract Yaml getYaml();

    public abstract boolean isDecrypt();

    public abstract void clear();

    public abstract void setClassLoader(ClassLoader var1);

    public abstract void putInConfigCache(String var1, Object var2);

    public static Config getInstance() {
        return FileConfigImpl.DEFAULT;
    }

    public static Config getNoneDecryptedInstance() {
        return NoneDecryptedConfigImpl.NONE_DECRYPTED;
    }

    static String convertStreamToString(InputStream is) {
        Scanner s2 = new Scanner(is).useDelimiter("\\A");
        return s2.hasNext() ? s2.next() : "";
    }

    public static Boolean loadBooleanValue(String name2, Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String s2 = (String)object;
            if ((s2 = s2.trim()).isEmpty()) {
                return false;
            }
            return Boolean.valueOf(s2);
        }
        throw new ConfigException(name2 + " must be a boolean or a string value.");
    }

    public static Integer loadIntegerValue(String name2, Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            String s2 = (String)object;
            if ((s2 = s2.trim()).isEmpty()) {
                return 0;
            }
            return Integer.valueOf(s2);
        }
        throw new ConfigException(name2 + " must be an integer or a string value.");
    }

    public static Long loadLongValue(String name2, Object object) {
        if (object instanceof Integer) {
            return (long)((Integer)object);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            String s2 = (String)object;
            if ((s2 = s2.trim()).isEmpty()) {
                return 0L;
            }
            return Long.valueOf(s2);
        }
        throw new ConfigException(name2 + " must be a long or a string value.");
    }

    static InputStream convertStringToStream(String string) {
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    private static final class FileConfigImpl
    extends AbstractConfigImpl {
        private static final Config DEFAULT = FileConfigImpl.initialize();
        final Yaml yaml;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FileConfigImpl() {
            String decryptorClass = this.getDecryptorClass();
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                if (null == decryptorClass || decryptorClass.trim().isEmpty()) {
                    this.yaml = new Yaml();
                } else {
                    Resolver resolver = new Resolver();
                    resolver.addImplicitResolver(YmlConstants.CRYPT_TAG, YmlConstants.CRYPT_PATTERN, "C");
                    this.yaml = new Yaml((BaseConstructor)DecryptConstructor.getInstance(decryptorClass), new Representer(new DumperOptions()), new DumperOptions(), resolver);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private static Config initialize() {
            Iterator<Config> it = ServiceLoader.load(Config.class).iterator();
            return it.hasNext() ? it.next() : new FileConfigImpl();
        }

        @Override
        public Yaml getYaml() {
            return this.yaml;
        }

        @Override
        public boolean isDecrypt() {
            return true;
        }
    }

    private static final class NoneDecryptedConfigImpl
    extends AbstractConfigImpl {
        private static final Config NONE_DECRYPTED = NoneDecryptedConfigImpl.initialize();
        final Yaml yaml;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NoneDecryptedConfigImpl() {
            Class<NoneDecryptedConfigImpl> clazz = NoneDecryptedConfigImpl.class;
            synchronized (NoneDecryptedConfigImpl.class) {
                this.yaml = new Yaml();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private static Config initialize() {
            Iterator<Config> it = ServiceLoader.load(Config.class).iterator();
            return it.hasNext() ? it.next() : new NoneDecryptedConfigImpl();
        }

        @Override
        public Yaml getYaml() {
            return this.yaml;
        }

        @Override
        public boolean isDecrypt() {
            return false;
        }
    }

    private static abstract class AbstractConfigImpl
    extends Config {
        static final String CONFIG_NAME = "config";
        static final String CONFIG_EXT_JSON = ".json";
        static final String CONFIG_EXT_YAML = ".yaml";
        static final String CONFIG_EXT_YML = ".yml";
        static final String[] configExtensionsOrdered = new String[]{".yml", ".yaml", ".json"};
        static final Logger logger = LoggerFactory.getLogger(NoneDecryptedConfigImpl.class);
        public final String[] EXTERNALIZED_PROPERTY_DIR = System.getProperty("light-4j-config-dir", "").split(File.pathSeparator);
        private ConfigLoader configLoader;
        private ClassLoader classLoader;
        private final String configLoaderClass;
        final Map<String, Object> configCache = new ConcurrentHashMap<String, Object>(10, 0.9f, 1);
        static final ObjectMapper mapper = new ObjectMapper();

        public AbstractConfigImpl() {
            this.configLoaderClass = this.getConfigLoaderClass();
        }

        @Override
        public ObjectMapper getMapper() {
            return mapper;
        }

        @Override
        public void clear() {
            this.configCache.clear();
        }

        @Override
        public void setClassLoader(ClassLoader classLoader2) {
            this.classLoader = classLoader2;
        }

        private ClassLoader getClassLoader() {
            if (this.classLoader != null) {
                return this.classLoader;
            }
            return this.getClass().getClassLoader();
        }

        @Override
        public void putInConfigCache(String configName, Object config) {
            this.configCache.put(configName, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getStringFromFile(String filename, String path) {
            String content = (String)this.configCache.get(filename);
            if (content != null) return content;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                content = (String)this.configCache.get(filename);
                if (content != null || (content = this.loadStringFromFile(filename, path)) == null) return content;
                this.configCache.put(filename, content);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return content;
            }
        }

        @Override
        public String getStringFromFile(String filename) {
            return this.getStringFromFile(filename, "");
        }

        @Override
        public InputStream getInputStreamFromFile(String filename) {
            return this.getConfigStream(filename, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getJsonObjectConfig(String configName, Class clazz, String path) {
            Object config = this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz2 = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = this.configCache.get(configName);
                if (config != null || (config = this.loadJsonObjectConfigWithSpecificConfigLoader(configName, clazz, path)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return config;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getDefaultJsonObjectConfig(String configName, Class clazz, String path) {
            Object config = this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz2 = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = this.configCache.get(configName);
                if (config != null || (config = this.loadObjectConfig(configName, clazz, path)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return config;
            }
        }

        @Override
        public Object getJsonObjectConfig(String configName, Class clazz) {
            return this.getJsonObjectConfig(configName, clazz, "");
        }

        @Override
        public Object getJsonObjectConfigNoCache(String configName, Class clazz) {
            return this.loadJsonObjectConfigWithSpecificConfigLoader(configName, clazz, "");
        }

        @Override
        public Object getDefaultJsonObjectConfig(String configName, Class clazz) {
            return this.getDefaultJsonObjectConfig(configName, clazz, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Map<String, Object> getJsonMapConfig(String configName, String path) {
            Map<String, Object> config = (Map<String, Object>)this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = (Map)this.configCache.get(configName);
                if (config != null || (config = this.loadJsonMapConfigWithSpecificConfigLoader(configName, path)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return config;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Map<String, Object> getDefaultJsonMapConfig(String configName, String path) {
            Map<String, Object> config = (Map<String, Object>)this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = (Map)this.configCache.get(configName);
                if (config != null || (config = this.loadMapConfig(configName, path)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return config;
            }
        }

        @Override
        public Map<String, Object> getJsonMapConfig(String configName) {
            return this.getJsonMapConfig(configName, "");
        }

        @Override
        public Map<String, Object> getDefaultJsonMapConfig(String configName) {
            return this.getDefaultJsonMapConfig(configName, "");
        }

        @Override
        public Map<String, Object> getJsonMapConfigNoCache(String configName, String path) {
            return this.loadJsonMapConfigWithSpecificConfigLoader(configName, path);
        }

        @Override
        public Map<String, Object> getDefaultJsonMapConfigNoCache(String configName, String path) {
            return this.loadMapConfig(configName, path);
        }

        @Override
        public Map<String, Object> getJsonMapConfigNoCache(String configName) {
            return this.getJsonMapConfigNoCache(configName, "");
        }

        @Override
        public Map<String, Object> getDefaultJsonMapConfigNoCache(String configName) {
            return this.getDefaultJsonMapConfigNoCache(configName, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String loadStringFromFile(String filename, String path) {
            String content = null;
            InputStream inStream = null;
            try {
                inStream = this.getConfigStream(filename, path);
                if (inStream != null) {
                    content = AbstractConfigImpl.convertStreamToString(inStream);
                }
            }
            catch (Exception ioe) {
                logger.error("Exception", ioe);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {
                        logger.error("IOException", ioe);
                    }
                }
            }
            return content;
        }

        private <T> Object loadSpecificConfigFileAsObject(String configName, String fileExtension2, Class<T> clazz, String path) {
            Object config = null;
            String fileName = configName + fileExtension2;
            try (InputStream inStream = this.getConfigStream(fileName, path);){
                if (inStream != null) {
                    if (ConfigInjection.isExclusionConfigFile(configName)) {
                        config = this.getYaml().loadAs(inStream, clazz);
                    } else {
                        Map configMap = (Map)this.getYaml().load(inStream);
                        config = CentralizedManagement.mergeObject(this.isDecrypt(), configMap, clazz);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception", e);
                throw new RuntimeException("Unable to load " + fileName + " as object.", e);
            }
            return config;
        }

        private <T> Object loadObjectConfig(String configName, Class<T> clazz, String path) {
            for (String extension : configExtensionsOrdered) {
                Object config = this.loadSpecificConfigFileAsObject(configName, extension, clazz, path);
                if (config == null) continue;
                return config;
            }
            return null;
        }

        private Map<String, Object> loadSpecificConfigFileAsMap(String configName, String fileExtension2, String path) {
            Map config = null;
            String ymlFilename = configName + fileExtension2;
            try (InputStream inStream = this.getConfigStream(ymlFilename, path);){
                if (inStream != null) {
                    config = (Map)this.getYaml().load(inStream);
                    if (!ConfigInjection.isExclusionConfigFile(configName)) {
                        CentralizedManagement.mergeMap(this.isDecrypt(), config);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception on loading " + ymlFilename, e);
                throw new RuntimeException("Unable to load " + ymlFilename + " as map.", e);
            }
            return config;
        }

        private Map<String, Object> loadMapConfig(String configName, String path) {
            for (String extension : configExtensionsOrdered) {
                Map<String, Object> config = this.loadSpecificConfigFileAsMap(configName, extension, path);
                if (config == null) continue;
                return config;
            }
            return null;
        }

        private InputStream getConfigStream(String configFilename, String path) {
            InputStream inStream = null;
            String configFileDir = null;
            for (int i = 0; i < this.EXTERNALIZED_PROPERTY_DIR.length; ++i) {
                block16: {
                    String absolutePath = this.getAbsolutePath(path, i);
                    try {
                        inStream = new FileInputStream(absolutePath + "/" + configFilename);
                        configFileDir = absolutePath;
                    }
                    catch (FileNotFoundException ex) {
                        if (!logger.isTraceEnabled() || configFilename == null || configFilename.contains("values")) break block16;
                        logger.trace("Unable to load config from externalized folder for {}", (Object)Encode.forJava(configFilename + " in " + absolutePath));
                    }
                }
                if (path.startsWith("/")) break;
            }
            if (inStream != null) {
                if (logger.isTraceEnabled() && configFilename != null && !configFilename.contains("values")) {
                    logger.trace("Config loaded from externalized folder for {}", (Object)Encode.forJava(configFilename + " in " + configFileDir));
                }
                return inStream;
            }
            if (logger.isTraceEnabled() && configFilename != null && !configFilename.contains("values")) {
                logger.trace("Trying to load config from classpath directory for file {}", (Object)Encode.forJava(configFilename));
            }
            if ((inStream = this.getClassLoader().getResourceAsStream(configFilename)) != null) {
                if (logger.isTraceEnabled() && configFilename != null && !configFilename.contains("values")) {
                    logger.trace("config loaded from classpath for {}", (Object)Encode.forJava(configFilename));
                }
                return inStream;
            }
            inStream = this.getClassLoader().getResourceAsStream("config/" + configFilename);
            if (inStream != null) {
                if (logger.isTraceEnabled() && configFilename != null && !configFilename.contains("values")) {
                    logger.trace("Config loaded from default folder for {}", (Object)Encode.forJava(configFilename));
                }
                return inStream;
            }
            assert (configFilename != null);
            if (configFilename.endsWith(CONFIG_EXT_YML)) {
                logger.trace("Unable to load config {}. Looking for the same file name with extension yaml...", (Object)Encode.forJava(configFilename));
            } else if (configFilename.endsWith(CONFIG_EXT_YAML)) {
                logger.trace("Unable to load config {}. Looking for the same file name with extension json...", (Object)Encode.forJava(configFilename));
            } else if (configFilename.endsWith(CONFIG_EXT_JSON)) {
                System.out.println("Unable to load config '" + Encode.forJava(configFilename.substring(0, configFilename.indexOf("."))) + "' with extension yml, yaml and json from external config, application config and module config. Please ignore this message if you are sure that your application is not using this config file.");
            }
            return null;
        }

        private static long getNextMidNightTime() {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            ((Calendar)cal).add(5, 1);
            return cal.getTimeInMillis();
        }

        private String getAbsolutePath(String path, int index) {
            if (path.startsWith("/")) {
                return path;
            }
            return path.isEmpty() ? this.EXTERNALIZED_PROPERTY_DIR[index].trim() : this.EXTERNALIZED_PROPERTY_DIR[index].trim() + "/" + path;
        }

        protected String getDecryptorClass() {
            Map<String, Object> config = this.loadModuleConfig();
            if (null != config) {
                String decryptorClass = (String)config.get("decryptorClass");
                if (logger.isTraceEnabled()) {
                    logger.trace("found decryptorClass={}", (Object)decryptorClass);
                }
                return decryptorClass == null ? DecryptConstructor.DEFAULT_DECRYPTOR_CLASS : decryptorClass;
            }
            logger.warn("config file cannot be found.");
            return DecryptConstructor.DEFAULT_DECRYPTOR_CLASS;
        }

        private String getConfigLoaderClass() {
            Map<String, Object> config = this.loadModuleConfig();
            if (null != config) {
                String configLoaderClass = (String)config.get("configLoaderClass");
                if (logger.isTraceEnabled()) {
                    logger.trace("found configLoaderClass={}", (Object)configLoaderClass);
                }
                return configLoaderClass;
            }
            logger.warn("config file cannot be found.");
            return null;
        }

        private Map<String, Object> loadModuleConfigNoCache() {
            Yaml yml = new Yaml();
            Map config = null;
            for (String extension : configExtensionsOrdered) {
                String ymlFilename = CONFIG_NAME + extension;
                try (InputStream inStream = this.getConfigStream(ymlFilename, "");){
                    if (inStream != null) {
                        config = (Map)yml.load(inStream);
                    }
                }
                catch (IOException ioe) {
                    logger.error("IOException", ioe);
                }
                if (config == null) continue;
                if (!logger.isTraceEnabled()) break;
                logger.trace("loaded config from file {}", (Object)ymlFilename);
                break;
            }
            return config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Map<String, Object> loadModuleConfig() {
            Map<String, Object> config = (Map<String, Object>)this.configCache.get(CONFIG_NAME);
            if (config != null) return config;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = (Map)this.configCache.get(CONFIG_NAME);
                if (config != null || (config = this.loadModuleConfigNoCache()) == null) return config;
                this.configCache.put(CONFIG_NAME, config);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return config;
            }
        }

        private Map<String, Object> loadJsonMapConfigWithSpecificConfigLoader(String configName, String path) {
            Map<String, Object> config = null;
            if (this.configLoaderClass != null && this.configLoader == null) {
                this.configLoader = ConfigLoaderConstructor.getInstance(this.configLoaderClass).getConfigLoader();
            }
            if (this.configLoader != null) {
                logger.trace("Trying to load {} with extension yaml, yml or json by using ConfigLoader: {}.", (Object)configName, (Object)this.configLoader.getClass().getName());
                config = path == null || path.equals("") ? this.configLoader.loadMapConfig(configName) : this.configLoader.loadMapConfig(configName, path);
            }
            if (config == null) {
                logger.trace("Trying to load {} with extension yaml, yml or json by using default loading method.", (Object)configName);
                config = this.loadMapConfig(configName, path);
            }
            return config;
        }

        private Object loadJsonObjectConfigWithSpecificConfigLoader(String configName, Class clazz, String path) {
            Object config = null;
            if (this.configLoaderClass != null && this.configLoader == null) {
                this.configLoader = ConfigLoaderConstructor.getInstance(this.configLoaderClass).getConfigLoader();
            }
            if (this.configLoader != null) {
                logger.trace("Trying to load {} with extension yaml, yml or json by using ConfigLoader: {}.", (Object)configName, (Object)this.configLoader.getClass().getName());
                config = path == null || path.isEmpty() ? this.configLoader.loadObjectConfig(configName, clazz) : this.configLoader.loadObjectConfig(configName, clazz, path);
            }
            if (config == null) {
                logger.trace("Trying to load {} with extension yaml, yml or json by using default loading method.", (Object)configName);
                config = this.loadObjectConfig(configName, clazz, path);
            }
            return config;
        }

        static {
            mapper.registerModule(new JavaTimeModule());
            mapper.registerModule(new Jdk8Module());
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        }
    }
}

