/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cluster;

import com.networknt.balance.LoadBalance;
import com.networknt.cluster.Cluster;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.Registry;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ConcurrentHashSet;
import com.networknt.utility.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightCluster
implements Cluster {
    private static Logger logger = LoggerFactory.getLogger(LightCluster.class);
    private static Registry registry = SingletonServiceFactory.getBean(Registry.class);
    private static LoadBalance loadBalance = SingletonServiceFactory.getBean(LoadBalance.class);
    private static final Set<URL> subscribedSet = new ConcurrentHashSet<URL>();
    private static final Map<String, List<URL>> serviceMap = new ConcurrentHashMap<String, List<URL>>();

    public LightCluster() {
        if (logger.isInfoEnabled()) {
            logger.info("A LightCluster instance is started");
        }
    }

    @Override
    public String serviceToUrl(String protocol, String serviceId, String tag, String requestKey) {
        if (StringUtils.isBlank(serviceId)) {
            logger.debug("The serviceId cannot be blank");
            return null;
        }
        URL url = loadBalance.select(this.discovery(protocol, serviceId, tag), serviceId, tag, requestKey);
        if (url != null) {
            logger.debug("Final url after load balance = {}.", (Object)url);
            return protocol + "://" + url.getHost() + ":" + url.getPort();
        }
        logger.debug("The service: {} cannot be found from service discovery.", (Object)serviceId);
        return null;
    }

    @Override
    public List<URI> services(String protocol, String serviceId, String tag) {
        if (StringUtils.isBlank(serviceId)) {
            logger.debug("The serviceId cannot be blank");
            return new ArrayList<URI>();
        }
        return this.discovery(protocol, serviceId, tag).stream().map(this::toUri).collect(Collectors.toList());
    }

    private List<URL> discovery(String protocol, String serviceId, String tag) {
        if (logger.isDebugEnabled()) {
            logger.debug("Protocol = {} serviceId = {} tag = {}", protocol, serviceId, tag);
        }
        String key = tag == null ? serviceId : serviceId + "|" + tag;
        ArrayList urls = serviceMap.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Cached key {} urls {}", (Object)key, (Object)urls);
        }
        if (urls == null || urls.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("urls is null or empty, subscribe and discover...");
            }
            URL subscribeUrl = URLImpl.valueOf(protocol + "://localhost/" + serviceId);
            if (tag != null) {
                subscribeUrl.addParameter("environment", tag);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("subscribeUrl = {}", (Object)subscribeUrl);
            }
            if (!subscribedSet.contains(subscribeUrl)) {
                registry.subscribe(subscribeUrl, new ClusterNotifyListener(serviceId, tag));
                subscribedSet.add(subscribeUrl);
            }
            urls = registry.discover(subscribeUrl);
            if (logger.isDebugEnabled()) {
                logger.debug("discovered urls = {}", (Object)urls);
            }
            serviceMap.put(key, urls == null ? new ArrayList() : urls);
        }
        return urls;
    }

    private URI toUri(URL url) {
        URI uri = null;
        try {
            uri = new URI(url.getProtocol(), null, url.getHost(), url.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            logger.error("URISyntaxExcpetion", e);
        }
        return uri;
    }

    static class ClusterNotifyListener
    implements NotifyListener {
        private final String serviceId;
        private final String tag;

        ClusterNotifyListener(String serviceId, String tag) {
            this.serviceId = serviceId;
            this.tag = tag;
        }

        @Override
        public void notify(URL registryUrl, List<URL> urls) {
            logger.debug("registryUrl is: {}", (Object)registryUrl);
            logger.debug("notify service: {} tag: {} with updated urls: {}", this.serviceId, this.tag, ((Object)urls).toString());
            if (StringUtils.isNotBlank(this.serviceId)) {
                String key = this.tag == null ? this.serviceId : this.serviceId + "|" + this.tag;
                serviceMap.put(key, urls == null ? new ArrayList() : urls);
            }
        }
    }
}

