/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ClientX509ExtendedTrustManager
implements X509TrustManager {
    private final X509TrustManager trustManager;

    public ClientX509ExtendedTrustManager(List<TrustManager> trustManagers) {
        if (trustManagers == null || trustManagers.size() == 0) {
            throw new IllegalArgumentException("TrustManagers must not be null or empty");
        }
        this.trustManager = (X509TrustManager)trustManagers.get(0);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
            return;
        }
        catch (CertificateException e) {
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(Arrays.asList(this.trustManager.getAcceptedIssuers()));
        return certificates.toArray(new X509Certificate[0]);
    }
}

