/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.simplepool;

import com.networknt.client.simplepool.SimpleConnection;
import com.networknt.client.simplepool.SimpleConnectionHolder;
import com.networknt.client.simplepool.SimpleConnectionMaker;
import io.undertow.connector.ByteBufferPool;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public final class SimpleURIConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(SimpleURIConnectionPool.class);
    private final SimpleConnectionMaker connectionMaker;
    private final long EXPIRY_TIME;
    private final int poolSize;
    private final URI uri;
    private InetSocketAddress bindAddress;
    private XnioWorker worker;
    private ByteBufferPool bufferPool;
    private XnioSsl ssl;
    private OptionMap options;
    private final Set<SimpleConnection> allCreatedConnections = ConcurrentHashMap.newKeySet();
    private final Set<SimpleConnectionHolder> allKnownConnections = new HashSet<SimpleConnectionHolder>();
    private final Set<SimpleConnectionHolder> borrowable = new HashSet<SimpleConnectionHolder>();
    private final Set<SimpleConnectionHolder> borrowed = new HashSet<SimpleConnectionHolder>();
    private final Set<SimpleConnectionHolder> notBorrowedExpired = new HashSet<SimpleConnectionHolder>();

    public SimpleURIConnectionPool(URI uri, long expireTime, int poolSize, SimpleConnectionMaker connectionMaker) {
        this.EXPIRY_TIME = expireTime;
        this.uri = uri;
        this.poolSize = poolSize;
        this.connectionMaker = connectionMaker;
    }

    public SimpleURIConnectionPool(URI uri, long expireTime, int poolSize, InetSocketAddress bindAddress, XnioWorker worker, ByteBufferPool bufferPool, XnioSsl ssl, OptionMap options, SimpleConnectionMaker connectionMaker) {
        this.EXPIRY_TIME = expireTime;
        this.uri = uri;
        this.poolSize = poolSize;
        this.bindAddress = bindAddress;
        this.worker = worker;
        this.bufferPool = bufferPool;
        this.ssl = ssl;
        this.options = options;
        this.connectionMaker = connectionMaker;
    }

    public synchronized SimpleConnectionHolder.ConnectionToken borrow(long createConnectionTimeout) throws RuntimeException {
        SimpleConnectionHolder holder;
        long now = System.currentTimeMillis();
        this.readAllConnectionHolders(now);
        if (this.borrowable.size() > 0) {
            holder = this.borrowable.toArray(new SimpleConnectionHolder[0])[ThreadLocalRandom.current().nextInt(this.borrowable.size())];
        } else if (this.allKnownConnections.size() < this.poolSize) {
            holder = new SimpleConnectionHolder(this.EXPIRY_TIME, createConnectionTimeout, this.uri, this.bindAddress, this.worker, this.bufferPool, this.ssl, this.options, this.allCreatedConnections, this.connectionMaker);
            this.allKnownConnections.add(holder);
        } else {
            throw new RuntimeException("An attempt was made to exceed the maximum size was of the " + this.uri.toString() + " connection pool");
        }
        SimpleConnectionHolder.ConnectionToken connectionToken = holder.borrow(createConnectionTimeout, now);
        this.readConnectionHolder(holder, now, () -> this.allKnownConnections.remove(holder));
        logger.debug(this.showConnections("borrow"));
        return connectionToken;
    }

    public synchronized void restore(SimpleConnectionHolder.ConnectionToken connectionToken) {
        if (connectionToken == null) {
            return;
        }
        SimpleConnectionHolder holder = connectionToken.holder();
        long now = System.currentTimeMillis();
        holder.restore(connectionToken);
        this.readAllConnectionHolders(now);
        logger.debug(this.showConnections("restore"));
    }

    private void readAllConnectionHolders(long now) {
        Iterator<SimpleConnectionHolder> knownConnectionHolders = this.allKnownConnections.iterator();
        while (knownConnectionHolders.hasNext()) {
            SimpleConnectionHolder connection = knownConnectionHolders.next();
            if (connection.closed()) {
                logger.debug("[{}: CLOSED]: Connection unexpectedly closed - Removing from known-connections set", (Object)SimpleURIConnectionPool.port(connection.connection()));
                this.readConnectionHolder(connection, now, knownConnectionHolders::remove);
                continue;
            }
            this.readConnectionHolder(connection, now, knownConnectionHolders::remove);
            if (!this.notBorrowedExpired.contains(connection)) continue;
            connection.safeClose(now);
            this.readConnectionHolder(connection, now, knownConnectionHolders::remove);
        }
        this.findAndCloseLeakedConnections();
    }

    private void readConnectionHolder(SimpleConnectionHolder connection, long now, RemoveFromAllKnownConnections knownConnections) {
        if (connection.closed()) {
            logger.debug("[{}: CLOSED]: Connection closed - Stopping connection tracking", (Object)SimpleURIConnectionPool.port(connection.connection()));
            this.allCreatedConnections.remove(connection.connection());
            knownConnections.remove();
            this.borrowable.remove(connection);
            this.borrowed.remove(connection);
            this.notBorrowedExpired.remove(connection);
            return;
        }
        boolean isExpired = connection.expired(now);
        boolean isBorrowed = connection.borrowed();
        boolean isBorrowable = connection.borrowable(now);
        boolean isNotBorrowedExpired = !isBorrowed && isExpired;
        this.updateSet(this.borrowable, isBorrowable, connection);
        this.updateSet(this.borrowed, isBorrowed, connection);
        this.updateSet(this.notBorrowedExpired, isNotBorrowedExpired, connection);
    }

    private void updateSet(Set<SimpleConnectionHolder> set, boolean isMember, SimpleConnectionHolder connectionHolder) {
        if (isMember) {
            set.add(connectionHolder);
        } else {
            set.remove(connectionHolder);
        }
    }

    private void findAndCloseLeakedConnections() {
        for (SimpleConnectionHolder knownConnection : this.allKnownConnections) {
            this.allCreatedConnections.remove(knownConnection.connection());
        }
        if (this.allCreatedConnections.size() > 0) {
            logger.debug("{} untracked connection found", (Object)this.allCreatedConnections.size());
            Iterator<SimpleConnection> leakedConnections = this.allCreatedConnections.iterator();
            while (leakedConnections.hasNext()) {
                SimpleConnection leakedConnection = leakedConnections.next();
                if (leakedConnection.isOpen()) {
                    leakedConnection.safeClose();
                    logger.debug("Connection closed {} -> {}", (Object)SimpleURIConnectionPool.port(leakedConnection), (Object)this.uri.toString());
                } else {
                    logger.debug("Connection was already closed {} -> {}", (Object)SimpleURIConnectionPool.port(leakedConnection), (Object)this.uri.toString());
                }
                leakedConnections.remove();
            }
        }
    }

    private String showConnections(String transitionName) {
        return "After " + transitionName + " - " + SimpleURIConnectionPool.showConnections("BORROWABLE", this.borrowable) + SimpleURIConnectionPool.showConnections("BORROWED", this.borrowed) + SimpleURIConnectionPool.showConnections("NOT_BORROWED_EXPIRED", this.notBorrowedExpired) + SimpleURIConnectionPool.showConnections("TRACKED", this.allKnownConnections);
    }

    private static String showConnections(String name2, Set<SimpleConnectionHolder> set) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(name2).append(": ");
        if (set.size() == 0) {
            sb.append("0");
        } else {
            int numCons = set.size();
            for (SimpleConnectionHolder holder : set) {
                sb.append(SimpleURIConnectionPool.port(holder.connection()));
                if (--numCons <= 0) continue;
                sb.append(" ");
            }
        }
        sb.append("] ");
        return sb.toString();
    }

    private static String port(SimpleConnection connection) {
        if (connection == null) {
            return "NULL";
        }
        String url = connection.getLocalAddress();
        int semiColon = url.lastIndexOf(":");
        if (semiColon == -1) {
            return "PORT?";
        }
        return url.substring(url.lastIndexOf(":") + 1);
    }

    private static interface RemoveFromAllKnownConnections {
        public void remove();
    }
}

