/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.simplepool;

import com.networknt.client.simplepool.SimpleConnectionHolder;
import com.networknt.client.simplepool.SimpleConnectionMaker;
import com.networknt.client.simplepool.SimpleURIConnectionPool;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SimpleConnectionPool {
    private final Map<URI, SimpleURIConnectionPool> pools = new ConcurrentHashMap<URI, SimpleURIConnectionPool>();
    private final SimpleConnectionMaker connectionMaker;
    private final long expireTime;
    private final int poolSize;

    public SimpleConnectionPool(long expireTime, int poolSize, SimpleConnectionMaker connectionMaker) {
        this.expireTime = expireTime;
        this.poolSize = poolSize;
        this.connectionMaker = connectionMaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleConnectionHolder.ConnectionToken borrow(long createConnectionTimeout, boolean isHttp2, URI uri) throws RuntimeException {
        if (!this.pools.containsKey(uri)) {
            Map<URI, SimpleURIConnectionPool> map = this.pools;
            synchronized (map) {
                if (!this.pools.containsKey(uri)) {
                    this.pools.put(uri, new SimpleURIConnectionPool(uri, this.expireTime, this.poolSize, this.connectionMaker));
                }
            }
        }
        return this.pools.get(uri).borrow(createConnectionTimeout);
    }

    public void restore(SimpleConnectionHolder.ConnectionToken connectionToken) {
        if (this.pools.containsKey(connectionToken.uri())) {
            this.pools.get(connectionToken.uri()).restore(connectionToken);
        }
    }
}

