/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.config.Config;
import com.networknt.status.Status;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCodeRequest
extends TokenRequest {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationCodeRequest.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    private String authCode;
    private String redirectUri;

    public AuthorizationCodeRequest() {
        this.setGrantType("authorization_code");
        Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
        if (tokenConfig != null) {
            Map acConfig;
            this.setServerUrl((String)tokenConfig.get("server_url"));
            this.setProxyHost((String)tokenConfig.get("proxyHost"));
            int port = tokenConfig.get("proxyPort") == null ? 443 : Config.loadIntegerValue("proxyPort", tokenConfig.get("proxyPort"));
            this.setProxyPort(port);
            this.setServiceId((String)tokenConfig.get("serviceId"));
            Object object = tokenConfig.get("enableHttp2");
            if (object != null) {
                this.setEnableHttp2(Config.loadBooleanValue("enableHttp2", object));
            }
            if ((acConfig = (Map)tokenConfig.get("authorization_code")) != null) {
                this.setClientId((String)acConfig.get("client_id"));
                if (acConfig.get("client_secret") != null) {
                    this.setClientSecret((String)acConfig.get("client_secret"));
                } else {
                    logger.error(new Status(CONFIG_PROPERTY_MISSING, "authorization_code client_secret", "client.yml").toString());
                }
                this.setUri((String)acConfig.get("uri"));
                this.setScope(this.loadScope(acConfig));
                this.setRedirectUri((String)acConfig.get("redirect_uri"));
            }
        }
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }
}

