/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.http;

import com.networknt.client.http.BodyPart;
import com.networknt.common.ContentType;
import com.networknt.status.HttpStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HttpResponseValue
implements Serializable {
    private Map<String, BodyPart> bodyPartMap;
    private final HttpStatus status;

    public HttpResponseValue() {
        this(null);
    }

    public HttpResponseValue(HttpStatus status) {
        this(status, null);
    }

    public HttpResponseValue(HttpStatus status, Map<String, BodyPart> bodyPartMap) {
        this.status = status;
        this.bodyPartMap = bodyPartMap;
    }

    public void setBody(HashMap<String, BodyPart> bodyPartMap) {
        this.bodyPartMap = bodyPartMap;
    }

    public HttpStatus getStatusCode() {
        return this.status;
    }

    public Map<String, BodyPart> getBody() {
        return this.bodyPartMap;
    }

    public BodyPart getBody(String key) {
        return this.bodyPartMap == null ? null : this.bodyPartMap.get(key);
    }

    public boolean hasBody(String key) {
        return this.bodyPartMap == null ? false : this.bodyPartMap.containsKey(key);
    }

    public static DefaultResponseValueBuilder builder() {
        return new DefaultResponseValueBuilder();
    }

    public static DefaultResponseValueBuilder builder(HttpStatus status) {
        return new DefaultResponseValueBuilder(status);
    }

    public static class DefaultResponseValueBuilder
    implements Serializable {
        private Map<String, BodyPart> mappings = new HashMap<String, BodyPart>();
        private HttpStatus status;

        public DefaultResponseValueBuilder() {
        }

        public DefaultResponseValueBuilder(HttpStatus status) {
            this.status = status;
        }

        public DefaultResponseValueBuilder with(String name2, ContentType type, Object body) {
            this.mappings.put(name2, new BodyPart<Object>(type, body));
            return this;
        }

        public HttpResponseValue build() {
            return new HttpResponseValue(this.status, this.mappings);
        }
    }
}

