/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.http;

import com.networknt.client.Http2Client;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientResponse;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ClientCompletableFutureWithRequest
extends CompletableFuture<ClientResponse>
implements ClientCallback<ClientExchange> {
    private Logger logger = LoggerFactory.getLogger(Http2ClientCompletableFutureWithRequest.class);
    private String requestBody;

    public Http2ClientCompletableFutureWithRequest(String requestBody) {
        this.requestBody = requestBody;
    }

    @Override
    public void completed(ClientExchange result2) {
        new StringWriteChannelListener(this.requestBody).setup(result2.getRequestChannel());
        result2.setResponseListener(new ClientCallback<ClientExchange>(){

            @Override
            public void completed(final ClientExchange result2) {
                new StringReadChannelListener(Http2Client.BUFFER_POOL){

                    @Override
                    protected void stringDone(String string) {
                        if (Http2ClientCompletableFutureWithRequest.this.logger.isDebugEnabled()) {
                            Http2ClientCompletableFutureWithRequest.this.logger.debug("Service call response = {}", (Object)string);
                        }
                        result2.getResponse().putAttachment(Http2Client.RESPONSE_BODY, string);
                        Http2ClientCompletableFutureWithRequest.this.complete(result2.getResponse());
                    }

                    @Override
                    protected void error(IOException e) {
                        Http2ClientCompletableFutureWithRequest.this.logger.error("IOException:", e);
                        Http2ClientCompletableFutureWithRequest.this.completeExceptionally(e);
                    }
                }.setup(result2.getResponseChannel());
            }

            @Override
            public void failed(IOException e) {
                Http2ClientCompletableFutureWithRequest.this.logger.error("IOException:", e);
                Http2ClientCompletableFutureWithRequest.this.completeExceptionally(e);
            }
        });
    }

    @Override
    public void failed(IOException e) {
        this.logger.error("IOException:", e);
        this.completeExceptionally(e);
    }
}

