/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.http;

import com.networknt.client.Http2Client;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientResponse;
import io.undertow.util.StringReadChannelListener;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListeners;

public class Http2ClientCompletableFutureNoRequest
extends CompletableFuture<ClientResponse>
implements ClientCallback<ClientExchange> {
    private Logger logger = LoggerFactory.getLogger(Http2ClientCompletableFutureNoRequest.class);

    @Override
    public void completed(ClientExchange result2) {
        result2.setResponseListener(new ClientCallback<ClientExchange>(){

            @Override
            public void completed(final ClientExchange result2) {
                new StringReadChannelListener(result2.getConnection().getBufferPool()){

                    @Override
                    protected void stringDone(String string) {
                        if (Http2ClientCompletableFutureNoRequest.this.logger.isDebugEnabled()) {
                            Http2ClientCompletableFutureNoRequest.this.logger.debug("Service call response = {}", (Object)string);
                        }
                        result2.getResponse().putAttachment(Http2Client.RESPONSE_BODY, string);
                        Http2ClientCompletableFutureNoRequest.super.complete(result2.getResponse());
                    }

                    @Override
                    protected void error(IOException e) {
                        Http2ClientCompletableFutureNoRequest.this.logger.error("IOException:", e);
                        Http2ClientCompletableFutureNoRequest.this.completeExceptionally(e);
                    }
                }.setup(result2.getResponseChannel());
            }

            @Override
            public void failed(IOException e) {
                Http2ClientCompletableFutureNoRequest.this.logger.error("IOException:", e);
                Http2ClientCompletableFutureNoRequest.this.completeExceptionally(e);
            }
        });
        try {
            result2.getRequestChannel().shutdownWrites();
            if (!result2.getRequestChannel().flush()) {
                result2.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                result2.getRequestChannel().resumeWrites();
            }
        }
        catch (IOException e) {
            this.logger.error("IOException:", e);
            this.completeExceptionally(e);
        }
    }

    @Override
    public void failed(IOException e) {
        this.logger.error("IOException:", e);
        this.completeExceptionally(e);
    }
}

