/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.client.AsyncResponse;
import com.networknt.client.AsyncResult;
import com.networknt.client.ClientConfig;
import com.networknt.client.DefaultAsyncResult;
import com.networknt.client.circuitbreaker.CircuitBreaker;
import com.networknt.client.http.Http2ClientCompletableFutureNoRequest;
import com.networknt.client.http.Http2ClientCompletableFutureWithRequest;
import com.networknt.client.http.Http2ClientConnectionPool;
import com.networknt.client.http.Light4jHttp2ClientProvider;
import com.networknt.client.http.Light4jHttpClientProvider;
import com.networknt.client.listener.ByteBufferReadChannelListener;
import com.networknt.client.listener.ByteBufferWriteChannelListener;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.TokenManager;
import com.networknt.client.simplepool.SimpleConnectionHolder;
import com.networknt.client.simplepool.SimpleConnectionMaker;
import com.networknt.client.simplepool.SimpleURIConnectionPool;
import com.networknt.client.simplepool.undertow.SimpleClientConnectionMaker;
import com.networknt.client.ssl.ClientX509ExtendedTrustManager;
import com.networknt.client.ssl.CompositeX509TrustManager;
import com.networknt.cluster.Cluster;
import com.networknt.config.Config;
import com.networknt.config.TlsUtil;
import com.networknt.exception.ClientException;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientProvider;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class Http2Client {
    private static final Logger logger = LoggerFactory.getLogger(Http2Client.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    public static final String CONFIG_NAME = "client";
    public static final OptionMap DEFAULT_OPTIONS = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, "Client").getMap();
    public static XnioWorker WORKER;
    @Deprecated
    public static XnioSsl SSL;
    public static final AttachmentKey<String> RESPONSE_BODY;
    public static AttachmentKey<ByteBuffer> BUFFER_BODY;
    public static final String HTTPS = "https";
    public static final String TLS = "tls";
    static final String LOAD_TRUST_STORE = "loadTrustStore";
    static final String LOAD_KEY_STORE = "loadKeyStore";
    static final String LOAD_DEFAULT_TRUST = "loadDefaultTrustStore";
    static final String TRUST_STORE = "trustStore";
    static final String TRUST_STORE_PASS = "trustStorePass";
    static final String DEFAULT_CERT_PASS = "defaultCertPassword";
    static final String KEY_STORE = "keyStore";
    static final String KEY_STORE_PASS = "keyStorePass";
    static final String KEY_PASS = "keyPass";
    static final String TLS_VERSION = "tlsVersion";
    static final String KEY_STORE_PROPERTY = "javax.net.ssl.keyStore";
    static final String KEY_STORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    static final String TRUST_STORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    static final String TRUST_STORE_TYPE_PROPERTY = "javax.net.ssl.trustStoreType";
    static final String SERVICE_ID = "serviceId";
    static String callerId;
    static String MASK_KEY_CLIENT_SECRET;
    static String MASK_KEY_TRUST_STORE_PASS;
    static String MASK_KEY_KEY_STORE_PASS;
    static String MASK_KEY_KEY_PASS;
    private final TokenManager tokenManager = TokenManager.getInstance();
    private final Http2ClientConnectionPool http2ClientConnectionPool = Http2ClientConnectionPool.getInstance();
    private final Map<URI, SimpleURIConnectionPool> pools = new ConcurrentHashMap<URI, SimpleURIConnectionPool>();
    public static ClientConfig config;
    public static ByteBufferPool BUFFER_POOL;
    protected final Map<String, ClientProvider> clientProviders;
    private static final Http2Client INSTANCE;

    protected Http2Client() {
        this(Http2Client.class.getClassLoader());
    }

    private Http2Client(ClassLoader classLoader2) {
        ServerConfig serverConfig;
        boolean injectCallerId;
        Map<String, Object> tlsMap = config.getTlsConfig();
        if (tlsMap == null || tlsMap.get("verifyHostname") == null || Boolean.FALSE.equals(Config.loadBooleanValue("verifyHostname", tlsMap.get("verifyHostname")))) {
            System.setProperty("io.undertow.client.https.disableEndpointIdentification", "true");
        }
        if ((injectCallerId = config.isInjectCallerId()) && (serverConfig = ServerConfig.getInstance()) != null) {
            callerId = serverConfig.getServiceId();
        }
        ServiceLoader<ClientProvider> providers = ServiceLoader.load(ClientProvider.class, classLoader2);
        HashMap<String, ClientProvider> map = new HashMap<String, ClientProvider>();
        for (ClientProvider provider : providers) {
            for (String scheme : provider.handlesSchemes()) {
                this.addProvider(map, scheme, provider);
            }
        }
        this.clientProviders = Collections.unmodifiableMap(map);
        try {
            Xnio xnio = Xnio.getInstance(Undertow.class.getClassLoader());
            WORKER = xnio.createWorker(null, DEFAULT_OPTIONS);
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
        List<String> masks = List.of(MASK_KEY_CLIENT_SECRET, MASK_KEY_TRUST_STORE_PASS, MASK_KEY_KEY_STORE_PASS, MASK_KEY_KEY_PASS);
        ModuleRegistry.registerModule(CONFIG_NAME, Http2Client.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache(CONFIG_NAME), masks);
    }

    private void addProvider(Map<String, ClientProvider> map, String scheme, ClientProvider provider) {
        if (System.getProperty("java.version").startsWith("1.8.")) {
            if (HTTPS.equalsIgnoreCase(scheme)) {
                map.putIfAbsent(scheme, new Light4jHttpClientProvider());
            } else if ("h2".equalsIgnoreCase(scheme)) {
                map.putIfAbsent(scheme, new Light4jHttp2ClientProvider());
            } else {
                map.put(scheme, provider);
            }
        } else {
            map.put(scheme, provider);
        }
    }

    public XnioSsl createXnioSsl(SSLContext sslContext) {
        return new UndertowXnioSsl(WORKER.getXnio(), OptionMap.EMPTY, BUFFER_POOL, sslContext);
    }

    @Deprecated
    public ClientConnection getFutureConnection(long timeoutSeconds, IoFuture<ClientConnection> future) {
        if (future.await(timeoutSeconds, TimeUnit.SECONDS) != IoFuture.Status.DONE) {
            throw new RuntimeException("Connection establishment timed out");
        }
        ClientConnection connection = null;
        try {
            connection = future.get();
        }
        catch (IOException e) {
            throw new RuntimeException("Connection establishment generated I/O exception", e);
        }
        if (connection == null) {
            throw new RuntimeException("Connection establishment failed (null) - Full connection terminated");
        }
        return connection;
    }

    @Deprecated
    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(uri, worker, null, bufferPool, options);
    }

    @Deprecated
    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioWorker worker, ByteBufferPool bufferPool, boolean isHttp2) {
        if (logger.isDebugEnabled()) {
            logger.debug("The connection is http2?:" + isHttp2);
        }
        return this.borrowConnection(uri, worker, bufferPool, isHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY);
    }

    public SimpleConnectionHolder.ConnectionToken borrow(URI uri, XnioWorker worker, ByteBufferPool bufferPool, boolean isHttp2) {
        if (logger.isDebugEnabled()) {
            logger.debug("The connection is http2?:" + isHttp2);
        }
        return this.borrow(uri, worker, bufferPool, isHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY);
    }

    @Deprecated
    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult<ClientConnection> result2 = new FutureResult<ClientConnection>();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got an open connection from http2ClientConnectionPool");
            }
            result2.setResult(connection);
            return result2.getIoFuture();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got a null or non open connection: {} from http2ClientConnectionPool. Creating a new one ...", (Object)connection);
        }
        return this.connect(uri, worker, null, bufferPool, options);
    }

    public SimpleConnectionHolder.ConnectionToken borrow(URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        SimpleURIConnectionPool pool = this.pools.get(uri);
        if (pool == null) {
            SimpleConnectionMaker undertowConnectionMaker = SimpleClientConnectionMaker.instance();
            pool = new SimpleURIConnectionPool(uri, config.getConnectionExpireTime(), config.getConnectionPoolSize(), null, worker, bufferPool, null, options, undertowConnectionMaker);
            this.pools.putIfAbsent(uri, pool);
        }
        return pool.borrow(config.getTimeout());
    }

    @Deprecated
    public ClientConnection borrowConnection(long timeoutSeconds, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, worker, bufferPool, options);
        return this.getFutureConnection(timeoutSeconds, future);
    }

    @Deprecated
    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, worker, null, bufferPool, options);
    }

    @Deprecated
    public IoFuture<ClientConnection> borrowConnection(InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult<ClientConnection> result2 = new FutureResult<ClientConnection>();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got an open connection from http2ClientConnectionPool");
            }
            result2.setResult(connection);
            return result2.getIoFuture();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got a null or non open connection: {} from http2ClientConnectionPool. Creating a new one ...", (Object)connection);
        }
        return this.connect(bindAddress, uri, worker, null, bufferPool, options);
    }

    @Deprecated
    public ClientConnection borrowConnection(long timeoutSeconds, InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(bindAddress, uri, worker, bufferPool, options);
        return this.getFutureConnection(timeoutSeconds, future);
    }

    public XnioSsl getDefaultXnioSsl() {
        if (SSL == null) {
            try {
                SSL = this.createXnioSsl(Http2Client.createSSLContext());
            }
            catch (Exception e) {
                logger.error("Exception", e);
                throw new RuntimeException(e);
            }
        }
        return SSL;
    }

    @Deprecated
    public void returnConnection(ClientConnection connection) {
        this.http2ClientConnectionPool.resetConnectionStatus(connection);
    }

    public void restore(SimpleConnectionHolder.ConnectionToken token) {
        if (token == null) {
            return;
        }
        this.pools.get(token.uri()).restore(token);
    }

    @Deprecated
    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        return this.connect((InetSocketAddress)null, uri, worker, ssl, bufferPool, options);
    }

    @Deprecated
    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, boolean isHttp2) {
        if (logger.isDebugEnabled()) {
            logger.debug("The connection is http2?:" + isHttp2);
        }
        return this.borrowConnection(uri, worker, ssl, bufferPool, isHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY);
    }

    @Deprecated
    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult<ClientConnection> result2 = new FutureResult<ClientConnection>();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got an open connection from http2ClientConnectionPool");
            }
            result2.setResult(connection);
            return result2.getIoFuture();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got a null or non open connection: {} from http2ClientConnectionPool. Creating a new one ...", (Object)connection);
        }
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        return this.connect((InetSocketAddress)null, uri, worker, ssl, bufferPool, options);
    }

    public SimpleConnectionHolder.ConnectionToken borrow(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        SimpleURIConnectionPool pool;
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        if ((pool = this.pools.get(uri)) == null) {
            SimpleConnectionMaker undertowConnectionMaker = SimpleClientConnectionMaker.instance();
            pool = new SimpleURIConnectionPool(uri, config.getConnectionExpireTime(), config.getConnectionPoolSize(), null, worker, bufferPool, ssl, options, undertowConnectionMaker);
            this.pools.putIfAbsent(uri, pool);
        }
        return pool.borrow(config.getTimeout());
    }

    @Deprecated
    public ClientConnection borrowConnection(long timeoutSeconds, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, boolean isHttp2) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, worker, ssl, bufferPool, isHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY);
        return this.getFutureConnection(timeoutSeconds, future);
    }

    @Deprecated
    public ClientConnection borrowConnection(long timeoutSeconds, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, worker, ssl, bufferPool, options);
        return this.getFutureConnection(timeoutSeconds, future);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, final URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result2 = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding the new connection: {} to FutureResult and cache it for uri: {}", (Object)r, (Object)uri);
                }
                result2.setResult(r);
                Http2Client.this.http2ClientConnectionPool.cacheConnection(uri, r);
            }

            @Override
            public void failed(IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to get new connection for uri: {}", (Object)uri);
                }
                result2.setException(e);
            }
        }, bindAddress, uri, worker, ssl, bufferPool, options);
        return result2.getIoFuture();
    }

    @Deprecated
    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, ioThread, null, bufferPool, options);
    }

    @Deprecated
    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult<ClientConnection> result2 = new FutureResult<ClientConnection>();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got an open connection from http2ClientConnectionPool");
            }
            result2.setResult(connection);
            return result2.getIoFuture();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got a null or non open connection: {} from http2ClientConnectionPool. Creating a new one ...", (Object)connection);
        }
        return this.connect((InetSocketAddress)null, uri, ioThread, null, bufferPool, options);
    }

    @Deprecated
    public ClientConnection borrowConnection(long timeoutSeconds, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, ioThread, bufferPool, options);
        return this.getFutureConnection(timeoutSeconds, future);
    }

    @Deprecated
    public ClientConnection borrowConnection(long timeoutSeconds, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, boolean isHttp2) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, ioThread, bufferPool, isHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY);
        return this.getFutureConnection(timeoutSeconds, future);
    }

    @Deprecated
    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, ioThread, null, bufferPool, options);
    }

    @Deprecated
    public IoFuture<ClientConnection> borrowConnection(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult<ClientConnection> result2 = new FutureResult<ClientConnection>();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got an open connection from http2ClientConnectionPool");
            }
            result2.setResult(connection);
            return result2.getIoFuture();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got a null or non open connection: {} from http2ClientConnectionPool. Creating a new one ...", (Object)connection);
        }
        return this.connect(bindAddress, uri, ioThread, null, bufferPool, options);
    }

    @Deprecated
    public ClientConnection borrowConnection(long timeoutSeconds, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(bindAddress, uri, ioThread, bufferPool, options);
        return this.getFutureConnection(timeoutSeconds, future);
    }

    @Deprecated
    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        return this.connect((InetSocketAddress)null, uri, ioThread, ssl, bufferPool, options);
    }

    @Deprecated
    public IoFuture<ClientConnection> borrowConnection(URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        FutureResult<ClientConnection> result2 = new FutureResult<ClientConnection>();
        ClientConnection connection = this.http2ClientConnectionPool.getConnection(uri);
        if (connection != null && connection.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got an open connection from http2ClientConnectionPool");
            }
            result2.setResult(connection);
            return result2.getIoFuture();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got a null or non open connection: {} from http2ClientConnectionPool. Creating a new one ...", (Object)connection);
        }
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        return this.connect((InetSocketAddress)null, uri, ioThread, ssl, bufferPool, options);
    }

    @Deprecated
    public ClientConnection borrowConnection(long timeoutSeconds, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        IoFuture<ClientConnection> future = this.borrowConnection(uri, ioThread, ssl, bufferPool, options);
        return this.getFutureConnection(timeoutSeconds, future);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, final URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result2 = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding the new connection: {} to FutureResult and cache it for uri: {}", (Object)r, (Object)uri);
                }
                result2.setResult(r);
                Http2Client.this.http2ClientConnectionPool.cacheConnection(uri, r);
            }

            @Override
            public void failed(IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to get new connection for uri: {}", (Object)uri);
                }
                result2.setException(e);
            }
        }, bindAddress, uri, ioThread, ssl, bufferPool, options);
        return result2.getIoFuture();
    }

    @Deprecated
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, worker, null, bufferPool, options);
    }

    @Deprecated
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, worker, null, bufferPool, options);
    }

    @Deprecated
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, worker, ssl, bufferPool, options);
    }

    @Deprecated
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, ioThread, null, bufferPool, options);
    }

    @Deprecated
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, ioThread, null, bufferPool, options);
    }

    @Deprecated
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, ioThread, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && ssl == null) {
            ssl = this.getDefaultXnioSsl();
        }
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, ioThread, ssl, bufferPool, options);
    }

    private ClientProvider getClientProvider(URI uri) {
        return this.clientProviders.get(uri.getScheme());
    }

    public static Http2Client getInstance() {
        return INSTANCE;
    }

    public static Http2Client getInstance(ClassLoader classLoader2) {
        return new Http2Client(classLoader2);
    }

    public void addAuthToken(ClientRequest request, String token) {
        if (token != null && !((String)token).startsWith("Bearer ")) {
            token = ((String)token).toUpperCase().startsWith("BEARER ") ? "Bearer " + ((String)token).substring(7) : "Bearer " + (String)token;
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, (String)token);
    }

    public void addAuthTokenTrace(ClientRequest request, String token, String traceabilityId) {
        if (token != null && !((String)token).startsWith("Bearer ")) {
            token = ((String)token).toUpperCase().startsWith("BEARER ") ? "Bearer " + ((String)token).substring(7) : "Bearer " + (String)token;
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, (String)token);
        request.getRequestHeaders().put(HttpStringConstants.TRACEABILITY_ID, traceabilityId);
    }

    public Result addCcToken(ClientRequest request) {
        Result<Jwt> result2 = this.tokenManager.getJwt(request.getPath(), request.getRequestHeaders().getFirst("scope"), request.getRequestHeaders().getFirst(SERVICE_ID));
        if (result2.isFailure()) {
            return Failure.of(result2.getError());
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + result2.getResult().getJwt());
        return result2;
    }

    public Result addCcTokenTrace(ClientRequest request, String traceabilityId) {
        Result<Jwt> result2 = this.tokenManager.getJwt(request.getPath(), request.getRequestHeaders().getFirst("scope"), request.getRequestHeaders().getFirst(SERVICE_ID));
        if (result2.isFailure()) {
            return Failure.of(result2.getError());
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + result2.getResult().getJwt());
        request.getRequestHeaders().put(HttpStringConstants.TRACEABILITY_ID, traceabilityId);
        return result2;
    }

    public Result propagateHeaders(ClientRequest request, HttpServerExchange exchange) {
        String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        String tid = exchange.getRequestHeaders().getFirst(HttpStringConstants.TRACEABILITY_ID);
        String cid = exchange.getRequestHeaders().getFirst(HttpStringConstants.CORRELATION_ID);
        return this.populateHeader(request, token, cid, tid);
    }

    public Result populateHeader(ClientRequest request, String authToken, String correlationId, String traceabilityId) {
        Result<Jwt> result2 = this.tokenManager.getJwt(request.getPath(), request.getRequestHeaders().getFirst("scope"), request.getRequestHeaders().getFirst(SERVICE_ID));
        if (result2.isFailure()) {
            return Failure.of(result2.getError());
        }
        if (authToken == null) {
            authToken = "Bearer " + result2.getResult().getJwt();
        } else {
            request.getRequestHeaders().put(HttpStringConstants.SCOPE_TOKEN, "Bearer " + result2.getResult().getJwt());
        }
        request.getRequestHeaders().put(HttpStringConstants.CORRELATION_ID, correlationId);
        if (traceabilityId != null) {
            this.addAuthTokenTrace(request, (String)authToken, traceabilityId);
        } else {
            this.addAuthToken(request, (String)authToken);
        }
        if (config.isInjectCallerId()) {
            request.getRequestHeaders().put(HttpStringConstants.CALLER_ID, callerId);
        }
        return result2;
    }

    private static KeyStore loadKeyStore(String name2, char[] password) throws IOException {
        InputStream stream = Config.getInstance().getInputStreamFromFile(name2);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, password);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name2), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    public static SSLContext createSSLContext() throws IOException {
        SSLContext sslContext = null;
        KeyManager[] keyManagers = null;
        Map<String, Object> tlsMap = config.getTlsConfig();
        if (tlsMap != null) {
            try {
                Boolean loadKeyStore = tlsMap.get(LOAD_KEY_STORE) == null ? false : Config.loadBooleanValue(LOAD_KEY_STORE, tlsMap.get(LOAD_KEY_STORE));
                if (loadKeyStore != null && loadKeyStore.booleanValue()) {
                    String keyStoreName = System.getProperty(KEY_STORE_PROPERTY);
                    String keyStorePass = System.getProperty(KEY_STORE_PASSWORD_PROPERTY);
                    if (keyStoreName != null && keyStorePass != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading key store from system property at " + Encode.forJava(keyStoreName));
                        }
                    } else {
                        keyStoreName = (String)tlsMap.get(KEY_STORE);
                        keyStorePass = (String)tlsMap.get(KEY_STORE_PASS);
                        if (keyStorePass == null) {
                            logger.error(new Status(CONFIG_PROPERTY_MISSING, KEY_STORE_PASS, "client.yml").toString());
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading key store from config at " + Encode.forJava(keyStoreName));
                        }
                    }
                    if (keyStoreName != null && keyStorePass != null) {
                        String keyPass = (String)tlsMap.get(KEY_PASS);
                        if (keyPass == null) {
                            logger.error(new Status(CONFIG_PROPERTY_MISSING, KEY_PASS, "client.yml").toString());
                        }
                        KeyStore keyStore = TlsUtil.loadKeyStore(keyStoreName, keyStorePass.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        keyManagerFactory.init(keyStore, keyPass.toCharArray());
                        keyManagers = keyManagerFactory.getKeyManagers();
                    }
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IOException("Unable to initialise KeyManager[]", e);
            }
            TrustManager[] trustManagers = null;
            Boolean loadDefaultTrust = tlsMap.get(LOAD_DEFAULT_TRUST) == null ? false : Config.loadBooleanValue(LOAD_DEFAULT_TRUST, tlsMap.get(LOAD_DEFAULT_TRUST));
            ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
            try {
                Boolean loadTrustStore = tlsMap.get(LOAD_TRUST_STORE) == null ? false : Config.loadBooleanValue(LOAD_TRUST_STORE, tlsMap.get(LOAD_TRUST_STORE));
                if (loadTrustStore != null && loadTrustStore.booleanValue()) {
                    TrustManager[] defaultTrusts;
                    String trustStoreName = (String)tlsMap.get(TRUST_STORE);
                    String trustStorePass = (String)tlsMap.get(TRUST_STORE_PASS);
                    if (trustStorePass == null) {
                        logger.error(new Status(CONFIG_PROPERTY_MISSING, TRUST_STORE_PASS, "client.yml").toString());
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("Loading trust store from config at " + Encode.forJava(trustStoreName));
                    }
                    if (trustStoreName != null && trustStorePass != null) {
                        KeyStore trustStore = TlsUtil.loadKeyStore(trustStoreName, trustStorePass.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init(trustStore);
                        trustManagers = trustManagerFactory.getTrustManagers();
                    }
                    if (loadDefaultTrust != null && loadDefaultTrust.booleanValue() && (defaultTrusts = Http2Client.loadDefaultTrustStore()) != null && defaultTrusts.length > 0) {
                        trustManagerList.addAll(Arrays.asList(defaultTrusts));
                    }
                    if (trustManagers != null && trustManagers.length > 0) {
                        trustManagerList.addAll(Arrays.asList(trustManagers));
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("Unable to initialise TrustManager[]", e);
            }
            try {
                String tlsVersion = (String)tlsMap.get(TLS_VERSION);
                if (tlsVersion == null) {
                    tlsVersion = "TLSv1.2";
                }
                sslContext = SSLContext.getInstance(tlsVersion);
                if (loadDefaultTrust != null && loadDefaultTrust.booleanValue() && !trustManagerList.isEmpty()) {
                    TrustManager[] compositeTrustManagers = new TrustManager[]{new CompositeX509TrustManager(Http2Client.convertTrustManagers(trustManagerList))};
                    sslContext.init(keyManagers, compositeTrustManagers, null);
                }
                if (trustManagers == null || trustManagers.length == 0) {
                    logger.error("No trust store is loaded. Please check client.yml");
                }
                TrustManager[] extendedTrustManagers = new TrustManager[]{new ClientX509ExtendedTrustManager(trustManagerList)};
                sslContext.init(keyManagers, extendedTrustManagers, null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to create and initialise the SSLContext", e);
            }
        } else {
            logger.error("TLS configuration section is missing in client.yml");
        }
        return sslContext;
    }

    public static List<X509TrustManager> convertTrustManagers(List<TrustManager> trustManagerList) {
        ArrayList<X509TrustManager> x509TrustManagers = new ArrayList<X509TrustManager>();
        for (TrustManager trustManager : trustManagerList) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            x509TrustManagers.add((X509TrustManager)trustManager);
        }
        return x509TrustManagers;
    }

    public static TrustManager[] loadDefaultTrustStore() throws Exception {
        String trustStoreType;
        String locationProperty;
        Path location = null;
        String password = "changeit";
        Map<String, Object> tlsMap = config.getTlsConfig();
        if (tlsMap != null && tlsMap.get(DEFAULT_CERT_PASS) != null) {
            password = (String)tlsMap.get(DEFAULT_CERT_PASS);
        }
        if (!StringUtils.isEmpty(locationProperty = System.getProperty(TRUST_STORE_PROPERTY))) {
            Path p = Paths.get(locationProperty, new String[0]);
            File f = p.toFile();
            if (f.exists() && f.isFile() && f.canRead()) {
                location = p;
            }
        } else {
            String javaHome = System.getProperty("java.home");
            location = Paths.get(javaHome, "lib", "security", "jssecacerts");
            if (!location.toFile().exists()) {
                location = Paths.get(javaHome, "lib", "security", "cacerts");
            }
        }
        if (!location.toFile().exists()) {
            logger.warn("Cannot find system default trust store");
            return null;
        }
        String trustStorePass = System.getProperty(TRUST_STORE_PASSWORD_PROPERTY);
        if (!StringUtils.isEmpty(trustStorePass)) {
            password = trustStorePass;
        }
        String type = !StringUtils.isEmpty(trustStoreType = System.getProperty(TRUST_STORE_TYPE_PROPERTY)) ? trustStoreType : KeyStore.getDefaultType();
        KeyStore trustStore = KeyStore.getInstance(type, Security.getProvider("SUN"));
        try (InputStream is = Files.newInputStream(location, new OpenOption[0]);){
            trustStore.load(is, password.toCharArray());
            logger.info("JDK default trust store loaded from : {} .", (Object)location);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    public static String getFormDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result2 = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result2.append("&");
            }
            result2.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result2.append("=");
            result2.append(URLEncoder.encode(entry.getValue(), "UTF-8").replaceAll("\\+", "%20"));
        }
        return result2.toString();
    }

    public ClientCallback<ClientExchange> createClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result2) {
                result2.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result2) {
                        reference.set(result2.getResponse());
                        new StringReadChannelListener(result2.getConnection().getBufferPool()){

                            @Override
                            protected void stringDone(String string) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Service call response = {}", (Object)string);
                                }
                                result2.getResponse().putAttachment(RESPONSE_BODY, string);
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                logger.error("IOException:", e);
                                latch.countDown();
                            }
                        }.setup(result2.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        logger.error("IOException:", e);
                        latch.countDown();
                    }
                });
                try {
                    result2.getRequestChannel().shutdownWrites();
                    if (!result2.getRequestChannel().flush()) {
                        result2.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result2.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    logger.error("IOException:", e);
                    latch.countDown();
                }
            }

            @Override
            public void failed(IOException e) {
                logger.error("IOException:", e);
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> byteBufferClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result2) {
                result2.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result2) {
                        reference.set(result2.getResponse());
                        new ByteBufferReadChannelListener(result2.getConnection().getBufferPool()){

                            @Override
                            protected void bufferDone(List<Byte> out) {
                                byte[] byteArray = new byte[out.size()];
                                int index = 0;
                                for (byte b : out) {
                                    byteArray[index++] = b;
                                }
                                result2.getResponse().putAttachment(BUFFER_BODY, ByteBuffer.wrap(byteArray));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                latch.countDown();
                            }
                        }.setup(result2.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        latch.countDown();
                    }
                });
                try {
                    result2.getRequestChannel().shutdownWrites();
                    if (!result2.getRequestChannel().flush()) {
                        result2.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result2.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException var3) {
                    latch.countDown();
                }
            }

            @Override
            public void failed(IOException e) {
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> byteBufferClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch, final ByteBuffer requestBody) {
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result2) {
                new ByteBufferWriteChannelListener(requestBody).setup(result2.getRequestChannel());
                result2.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result2) {
                        reference.set(result2.getResponse());
                        new ByteBufferReadChannelListener(result2.getConnection().getBufferPool()){

                            @Override
                            protected void bufferDone(List<Byte> out) {
                                byte[] byteArray = new byte[out.size()];
                                int index = 0;
                                for (byte b : out) {
                                    byteArray[index++] = b;
                                }
                                result2.getResponse().putAttachment(BUFFER_BODY, ByteBuffer.wrap(byteArray));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                latch.countDown();
                            }
                        }.setup(result2.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        latch.countDown();
                    }
                });
                try {
                    result2.getRequestChannel().shutdownWrites();
                    if (!result2.getRequestChannel().flush()) {
                        result2.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result2.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException var3) {
                    latch.countDown();
                }
            }

            @Override
            public void failed(IOException e) {
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch, final String requestBody) {
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result2) {
                new StringWriteChannelListener(requestBody).setup(result2.getRequestChannel());
                result2.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result2) {
                        reference.set(result2.getResponse());
                        new StringReadChannelListener(BUFFER_POOL){

                            @Override
                            protected void stringDone(String string) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Service call response = {}", (Object)string);
                                }
                                result2.getResponse().putAttachment(RESPONSE_BODY, string);
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                logger.error("IOException:", e);
                                latch.countDown();
                            }
                        }.setup(result2.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        logger.error("IOException:", e);
                        latch.countDown();
                    }
                });
            }

            @Override
            public void failed(IOException e) {
                logger.error("IOException:", e);
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createFullCallback(final AtomicReference<AsyncResult<AsyncResponse>> reference, final CountDownLatch latch) {
        final long startTime = System.currentTimeMillis();
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result2) {
                result2.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result2) {
                        new StringReadChannelListener(result2.getConnection().getBufferPool()){

                            @Override
                            protected void stringDone(String string) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Service call response = {}", (Object)string);
                                }
                                AsyncResponse ar = new AsyncResponse(result2.getResponse(), string, System.currentTimeMillis() - startTime);
                                reference.set(DefaultAsyncResult.succeed(ar));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                logger.error("IOException:", e);
                                reference.set(DefaultAsyncResult.fail(e));
                                latch.countDown();
                            }
                        }.setup(result2.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        logger.error("IOException:", e);
                        reference.set(DefaultAsyncResult.fail(e));
                        latch.countDown();
                    }
                });
                try {
                    result2.getRequestChannel().shutdownWrites();
                    if (!result2.getRequestChannel().flush()) {
                        result2.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result2.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    logger.error("IOException:", e);
                    reference.set(DefaultAsyncResult.fail(e));
                    latch.countDown();
                }
            }

            @Override
            public void failed(IOException e) {
                logger.error("IOException:", e);
                reference.set(DefaultAsyncResult.fail(e));
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createFullCallback(final AtomicReference<AsyncResult<AsyncResponse>> reference, final CountDownLatch latch, final String requestBody) {
        final long startTime = System.currentTimeMillis();
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result2) {
                new StringWriteChannelListener(requestBody).setup(result2.getRequestChannel());
                result2.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result2) {
                        new StringReadChannelListener(BUFFER_POOL){

                            @Override
                            protected void stringDone(String string) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Service call response = {}", (Object)string);
                                }
                                AsyncResponse ar = new AsyncResponse(result2.getResponse(), string, System.currentTimeMillis() - startTime);
                                reference.set(DefaultAsyncResult.succeed(ar));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                logger.error("IOException:", e);
                                reference.set(DefaultAsyncResult.fail(e));
                                latch.countDown();
                            }
                        }.setup(result2.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        logger.error("IOException:", e);
                        reference.set(DefaultAsyncResult.fail(e));
                        latch.countDown();
                    }
                });
            }

            @Override
            public void failed(IOException e) {
                logger.error("IOException:", e);
                reference.set(DefaultAsyncResult.fail(e));
                latch.countDown();
            }
        };
    }

    public CircuitBreaker getRequestService(URI uri, ClientRequest request, Optional<String> requestBody) {
        return new CircuitBreaker(() -> this.callService(uri, request, requestBody));
    }

    public CircuitBreaker getRequestService(URI uri, ClientRequest request, Optional<String> requestBody, boolean isHttp2) {
        return new CircuitBreaker(() -> this.callService(uri, request, requestBody, isHttp2));
    }

    public CompletableFuture<ClientResponse> callService(URI uri, ClientRequest request, Optional<String> requestBody) {
        CompletableFuture<ClientResponse> futureClientResponse;
        this.addHostHeader(request);
        AtomicReference<ClientConnection> currentConnection = new AtomicReference<ClientConnection>(this.http2ClientConnectionPool.getConnection(uri));
        if (currentConnection.get() != null && currentConnection.get().isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Reusing the connection: {} to {}", (Object)currentConnection.toString(), (Object)uri.toString());
            }
            futureClientResponse = this.getFutureClientResponse(currentConnection.get(), uri, request, requestBody);
        } else {
            CompletableFuture<ClientConnection> futureConnection = this.connectAsync(uri);
            futureClientResponse = futureConnection.thenComposeAsync(clientConnection -> {
                currentConnection.set((ClientConnection)clientConnection);
                return this.getFutureClientResponse((ClientConnection)clientConnection, uri, request, requestBody);
            });
        }
        futureClientResponse.thenAcceptAsync(clientResponse -> this.http2ClientConnectionPool.resetConnectionStatus((ClientConnection)currentConnection.get()));
        return futureClientResponse;
    }

    public CompletableFuture<ClientResponse> callService(URI uri, ClientRequest request, Optional<String> requestBody, boolean isHttp2) {
        CompletableFuture<ClientResponse> futureClientResponse;
        this.addHostHeader(request);
        AtomicReference<ClientConnection> currentConnection = new AtomicReference<ClientConnection>(this.http2ClientConnectionPool.getConnection(uri));
        if (currentConnection.get() != null && currentConnection.get().isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Reusing the connection: {} to {}", (Object)currentConnection.toString(), (Object)uri.toString());
            }
            futureClientResponse = this.getFutureClientResponse(currentConnection.get(), uri, request, requestBody);
        } else {
            CompletableFuture<ClientConnection> futureConnection = this.connectAsync(uri, isHttp2);
            futureClientResponse = futureConnection.thenComposeAsync(clientConnection -> {
                currentConnection.set((ClientConnection)clientConnection);
                return this.getFutureClientResponse((ClientConnection)clientConnection, uri, request, requestBody);
            });
        }
        futureClientResponse.thenAcceptAsync(clientResponse -> this.http2ClientConnectionPool.resetConnectionStatus((ClientConnection)currentConnection.get()));
        return futureClientResponse;
    }

    public CompletableFuture<ClientResponse> callService(String protocol, String serviceId, String envTag, ClientRequest request, Optional<String> requestBody) {
        try {
            Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
            String url = cluster.serviceToUrl(protocol, serviceId, envTag, null);
            if (url == null) {
                logger.error("Failed to discover service with serviceID: {}, and tag: {}", (Object)serviceId, (Object)envTag);
                throw new ClientException(String.format("Failed to discover service with serviceID: %s, and tag: %s", serviceId, envTag));
            }
            return this.callService(new URI(url), request, requestBody);
        }
        catch (Exception e) {
            logger.error("Failed to call service: {}", (Object)serviceId);
            throw new RuntimeException("Failed to call service: " + serviceId, e);
        }
    }

    public CompletableFuture<ClientResponse> callService(String protocol, String serviceId, String envTag, ClientRequest request, Optional<String> requestBody, boolean isHttp2) {
        try {
            Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
            String url = cluster.serviceToUrl(protocol, serviceId, envTag, null);
            if (url == null) {
                logger.error("Failed to discover service with serviceID: {}, and tag: {}", (Object)serviceId, (Object)envTag);
                throw new ClientException(String.format("Failed to discover service with serviceID: %s, and tag: %s", serviceId, envTag));
            }
            return this.callService(new URI(url), request, requestBody, isHttp2);
        }
        catch (Exception e) {
            logger.error("Failed to call service: {}", (Object)serviceId);
            throw new RuntimeException("Failed to call service: " + serviceId, e);
        }
    }

    public CompletableFuture<ClientConnection> connectAsync(URI uri) {
        if (HTTPS.equals(uri.getScheme()) && SSL == null) {
            SSL = this.getDefaultXnioSsl();
        }
        return this.connectAsync(null, uri, WORKER, SSL, BUFFER_POOL, config.getRequestEnableHttp2() ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY);
    }

    public CompletableFuture<ClientConnection> connectAsync(URI uri, boolean isHttp2) {
        if (HTTPS.equals(uri.getScheme()) && SSL == null) {
            SSL = this.getDefaultXnioSsl();
        }
        return this.connectAsync(null, uri, WORKER, SSL, BUFFER_POOL, isHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY);
    }

    public CompletableFuture<ClientConnection> connectAsync(InetSocketAddress bindAddress, final URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (HTTPS.equals(uri.getScheme()) && SSL == null) {
            SSL = this.getDefaultXnioSsl();
        }
        final CompletableFuture<ClientConnection> completableFuture = new CompletableFuture<ClientConnection>();
        ClientProvider provider = this.clientProviders.get(uri.getScheme());
        try {
            provider.connect(new ClientCallback<ClientConnection>(){

                @Override
                public void completed(ClientConnection r) {
                    completableFuture.complete(r);
                    Http2Client.this.http2ClientConnectionPool.cacheConnection(uri, r);
                }

                @Override
                public void failed(IOException e) {
                    completableFuture.completeExceptionally(e);
                }
            }, bindAddress, uri, worker, ssl, bufferPool, options);
        }
        catch (Throwable t2) {
            completableFuture.completeExceptionally(t2);
        }
        return completableFuture;
    }

    private CompletableFuture<ClientResponse> getFutureClientResponse(ClientConnection clientConnection, URI uri, ClientRequest request, Optional<String> requestBody) {
        if (requestBody.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("The request sent to {} = request header: {}, request body: {}", uri.toString(), request.getRequestHeaders().toString(), requestBody.get());
            }
            Http2ClientCompletableFutureWithRequest futureClientResponseWithRequest = new Http2ClientCompletableFutureWithRequest(requestBody.get());
            try {
                clientConnection.sendRequest(request, futureClientResponseWithRequest);
            }
            catch (Exception e) {
                futureClientResponseWithRequest.completeExceptionally(e);
            }
            return futureClientResponseWithRequest;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The request sent to {} = request header: {}, request body is empty", (Object)uri.toString(), (Object)request.getRequestHeaders().toString());
        }
        Http2ClientCompletableFutureNoRequest futureClientResponseNoRequest = new Http2ClientCompletableFutureNoRequest();
        try {
            clientConnection.sendRequest(request, futureClientResponseNoRequest);
        }
        catch (Exception e) {
            futureClientResponseNoRequest.completeExceptionally(e);
        }
        return futureClientResponseNoRequest;
    }

    private void addHostHeader(ClientRequest request) {
        if (!request.getRequestHeaders().contains(Headers.HOST)) {
            request.getRequestHeaders().put(Headers.HOST, "localhost");
        }
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        BUFFER_BODY = AttachmentKey.create(ByteBuffer.class);
        callerId = "unknown";
        MASK_KEY_CLIENT_SECRET = "client_secret";
        MASK_KEY_TRUST_STORE_PASS = TRUST_STORE_PASS;
        MASK_KEY_KEY_STORE_PASS = KEY_STORE_PASS;
        MASK_KEY_KEY_PASS = KEY_PASS;
        config = ClientConfig.get();
        BUFFER_POOL = new DefaultByteBufferPool(true, config.getBufferSize() * 1024);
        INSTANCE = new Http2Client();
    }
}

