/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.client.OAuthConfig;
import com.networknt.client.RequestConfig;
import com.networknt.client.TlsConfig;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.MapField;
import com.networknt.config.schema.ObjectField;
import com.networknt.config.schema.OutputFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="client", configName="client", configDescription="This is the configuration file for light-4j Http2Client and jdk 11 http-client.", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public final class ClientConfig {
    private static final Logger logger = LoggerFactory.getLogger(ClientConfig.class);
    public static final String CONFIG_NAME = "client";
    public static final String REQUEST = "request";
    public static final String SERVER_URL = "server_url";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String SERVICE_ID = "serviceId";
    public static final String URI = "uri";
    public static final String TLS = "tls";
    public static final String CLIENT_ID = "client_id";
    public static final String SCOPE = "scope";
    public static final String AUDIENCE = "audience";
    public static final String CSRF = "csrf";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String SAML_BEARER = "saml_bearer";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String AUTHORIZATION_CODE = "authorization_code";
    public static final String CLIENT_AUTHENTICATED_USER = "client_authenticated_user";
    public static final String CACHE = "cache";
    public static final String CAPACITY = "capacity";
    public static final String OAUTH = "oauth";
    public static final String PATH_PREFIX_SERVICES = "pathPrefixServices";
    public static final String SERVICE_ID_AUTH_SERVERS = "serviceIdAuthServers";
    public static final String KEY = "key";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String ENABLE_HTTP2 = "enableHttp2";
    public static final String TIMEOUT = "timeout";
    public static final String MAX_REQUEST_RETRY = "maxRequestRetry";
    public static final String REQUEST_RETRY_DELAY = "requestRetryDelay";
    public static final String TOKEN = "token";
    public static final int DEFAULT_BUFFER_SIZE = 24;
    public static final int DEFAULT_ERROR_THRESHOLD = 5;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_RESET_TIMEOUT = 600000;
    public static final String TOKEN_RENEW_BEFORE_EXPIRED = "tokenRenewBeforeExpired";
    public static final String EXPIRED_REFRESH_RETRY_DELAY = "expiredRefreshRetryDelay";
    public static final String EARLY_REFRESH_RETRY_DELAY = "earlyRefreshRetryDelay";
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;
    @ObjectField(configFieldName="tls", useSubObjectDefault=true, ref=TlsConfig.class, description="Settings for TLS")
    private TlsConfig tls;
    @ObjectField(configFieldName="oauth", useSubObjectDefault=true, ref=OAuthConfig.class, description="Settings for OAuth2 server communication.")
    private OAuthConfig oauthConfig;
    @MapField(configFieldName="pathPrefixServices", externalizedKeyName="pathPrefixServices", valueType=String.class, externalized=true, description="If you have multiple OAuth 2.0 providers and use path prefix to decide which OAuth 2.0 server\nto get the token or JWK. If two or more services have the same path, you must use serviceId in\nthe request header to use the serviceId to find the OAuth 2.0 provider configuration.")
    private Map<String, String> pathPrefixServices;
    @ObjectField(configFieldName="request", useSubObjectDefault=true, ref=RequestConfig.class, description="Circuit breaker configuration for the client")
    private RequestConfig request;
    private static volatile ClientConfig instance;

    private ClientConfig() {
        this.mappedConfig = this.config.getJsonMapConfig(CONFIG_NAME);
        this.load();
    }

    private ClientConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.load();
    }

    private void load() {
        if (this.mappedConfig != null) {
            this.setValues();
        }
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        if (this.mappedConfig != null) {
            this.setValues();
        }
    }

    private void setValues() {
        ObjectMapper mapper = Config.getInstance().getMapper();
        if (this.mappedConfig.get(REQUEST) instanceof Map) {
            this.request = mapper.convertValue(this.mappedConfig.get(REQUEST), RequestConfig.class);
        }
        if (this.mappedConfig.get(TLS) instanceof Map) {
            this.tls = mapper.convertValue(this.mappedConfig.get(TLS), TlsConfig.class);
        }
        if (this.mappedConfig.get(OAUTH) instanceof Map) {
            this.oauthConfig = mapper.convertValue(this.mappedConfig.get(OAUTH), OAuthConfig.class);
        }
        if (this.mappedConfig.get(PATH_PREFIX_SERVICES) != null && this.mappedConfig.get(PATH_PREFIX_SERVICES) instanceof Map) {
            this.pathPrefixServices = (Map)this.mappedConfig.get(PATH_PREFIX_SERVICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientConfig get() {
        if (instance != null) return instance;
        Class<ClientConfig> clazz = ClientConfig.class;
        synchronized (ClientConfig.class) {
            if (instance != null) return instance;
            instance = new ClientConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static ClientConfig get(String configName) {
        instance = new ClientConfig(configName);
        return instance;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public static Map<String, Object> getServiceIdAuthServers(Object object) {
        Map<Object, Object> serviceIdAuthServers = new HashMap();
        if (object instanceof Map) {
            serviceIdAuthServers = (Map)object;
        } else if (object instanceof String) {
            String s2 = (String)object;
            if ((s2 = s2.trim()).startsWith("{")) {
                serviceIdAuthServers = JsonMapper.string2Map(s2);
            } else {
                logger.error("The serviceIdAuthServers in client.yml is not a map or a JSON string.");
            }
        } else {
            logger.error("The serviceIdAuthServers in client.yml is not a map or a JSON string.");
        }
        return serviceIdAuthServers;
    }

    public OAuthConfig getOAuth() {
        return this.oauthConfig;
    }

    public RequestConfig getRequest() {
        return this.request;
    }

    public Map<String, String> getPathPrefixServices() {
        return this.pathPrefixServices;
    }

    @Deprecated(since="2.2.1")
    private void setTlsConfig() {
        ObjectMapper mapper = Config.getInstance().getMapper();
        this.tls = mapper.convertValue(this.mappedConfig.get(TLS), TlsConfig.class);
    }

    @Deprecated(since="2.2.1")
    public Map<String, Object> getTlsConfig() {
        ObjectMapper mapper = Config.getInstance().getMapper();
        return mapper.convertValue((Object)this.tls, new TypeReference<Map<String, Object>>(){});
    }

    @Deprecated(since="2.2.1")
    public Map<String, Object> getOauthConfig() {
        ObjectMapper mapper = Config.getInstance().getMapper();
        return mapper.convertValue((Object)this.oauthConfig, new TypeReference<Map<String, Object>>(){});
    }

    @Deprecated(since="2.2.1")
    public Map<String, Object> getTokenConfig() {
        ObjectMapper mapper = Config.getInstance().getMapper();
        return mapper.convertValue((Object)this.oauthConfig.getToken(), new TypeReference<Map<String, Object>>(){});
    }

    @Deprecated(since="2.2.1")
    public Map<String, Object> getDerefConfig() {
        ObjectMapper mapper = Config.getInstance().getMapper();
        return mapper.convertValue((Object)this.oauthConfig.getDeref(), new TypeReference<Map<String, Object>>(){});
    }

    @Deprecated(since="2.2.1")
    public Map<String, Object> getSignConfig() {
        ObjectMapper mapper = Config.getInstance().getMapper();
        return mapper.convertValue((Object)this.oauthConfig.getSign(), new TypeReference<Map<String, Object>>(){});
    }

    @Deprecated(since="2.2.1")
    public int getTimeout() {
        return this.request.getTimeout();
    }

    @Deprecated(since="2.2.1")
    public int getResetTimeout() {
        return this.request.getResetTimeout();
    }

    @Deprecated(since="2.2.1")
    public int getMaxRequestRetry() {
        return this.request.getMaxRequestRetry();
    }

    @Deprecated(since="2.2.1")
    public int getRequestRetryDelay() {
        return this.request.getRequestRetryDelay();
    }

    @Deprecated(since="2.2.1")
    public int getErrorThreshold() {
        return this.request.getErrorThreshold();
    }

    @Deprecated(since="2.2.1")
    public boolean isInjectOpenTracing() {
        return this.request.isInjectOpenTracing();
    }

    @Deprecated(since="2.2.1")
    public boolean isInjectCallerId() {
        return this.request.isInjectCallerId();
    }

    @Deprecated(since="2.2.1")
    public int getConnectionPoolSize() {
        return this.request.getConnectionPoolSize();
    }

    @Deprecated(since="2.2.1")
    public int getMaxRequestPerConnection() {
        return this.request.getMaxReqPerConn();
    }

    @Deprecated(since="2.2.1")
    public boolean getRequestEnableHttp2() {
        return this.request.isEnableHttp2();
    }

    public void setRequestEnableHttp2(boolean requestEnableHttp2) {
        this.request.setIsEnableHttp2(requestEnableHttp2);
    }

    @Deprecated(since="2.2.1")
    public long getConnectionExpireTime() {
        return this.request.getConnectionExpireTime();
    }

    @Deprecated(since="2.2.1")
    public int getMaxConnectionNumPerHost() {
        return this.request.getMaxConnectionNumPerHost();
    }

    @Deprecated(since="2.2.1")
    public int getMinConnectionNumPerHost() {
        return this.request.getMinConnectionNumPerHost();
    }

    @Deprecated(since="2.2.1")
    public boolean isMultipleAuthServers() {
        return this.oauthConfig.isMultipleAuthServers();
    }

    public int getBufferSize() {
        return 24;
    }
}

