/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cache;

import com.networknt.cache.CacheConfig;
import com.networknt.cache.CacheItem;
import com.networknt.config.Config;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ModuleRegistry;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CacheManager {
    public static final Logger logger = LoggerFactory.getLogger(CacheManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheManager getInstance() {
        if (Holder.initialized) return Holder.instance;
        Class<Holder> clazz = Holder.class;
        synchronized (Holder.class) {
            if (Holder.initialized) return Holder.instance;
            CacheConfig config = CacheConfig.load();
            ModuleRegistry.registerModule("cache", CacheManager.class.getName(), Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("cache"), null);
            List<CacheItem> caches = config.getCaches();
            if (caches != null && !caches.isEmpty()) {
                CacheManager cacheManager = SingletonServiceFactory.getBean(CacheManager.class);
                if (cacheManager != null) {
                    for (CacheItem cacheItem : caches) {
                        cacheManager.addCache(cacheItem.getCacheName(), cacheItem.getMaxSize(), cacheItem.getExpiryInMinutes());
                    }
                    Holder.instance = cacheManager;
                } else {
                    logger.error("CacheManager implementation is not found in the service.yml");
                }
            } else {
                logger.error("No cache is configured in cache.yml");
            }
            Holder.initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return Holder.instance;
        }
    }

    public void addCache(String var1, long var2, long var4);

    public Map<Object, Object> getCache(String var1);

    public void put(String var1, String var2, Object var3);

    public Object get(String var1, String var2);

    public void delete(String var1, String var2);

    public void removeCache(String var1);

    public int getSize(String var1);

    public static class Holder {
        static volatile boolean initialized = false;
        static volatile CacheManager instance = null;
    }
}

