/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.basicauth;

import com.networknt.basicauth.UserAuth;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.JsonMapper;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.MapField;
import com.networknt.config.schema.OutputFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ConfigSchema(configKey="basic", configName="basic-auth", configDescription="Basic Authentication Security Configuration for light-4j", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class BasicAuthConfig {
    public static final String CONFIG_NAME = "basic-auth";
    private static final String ENABLED = "enabled";
    private static final String ENABLE_AD = "enableAD";
    private static final String ALLOW_ANONYMOUS = "allowAnonymous";
    private static final String ALLOW_BEARER_TOKEN = "allowBearerToken";
    private static final String USERS = "users";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String PATHS = "paths";
    public static final String ANONYMOUS = "anonymous";
    public static final String BEARER = "bearer";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", externalized=true, defaultValue=false, description="Enable Basic Authentication Handler, default is true.")
    boolean enabled;
    @BooleanField(configFieldName="enableAD", externalizedKeyName="enableAD", externalized=true, defaultValue=true, description="Enable Ldap Authentication, default is true.")
    boolean enableAD;
    @BooleanField(configFieldName="allowAnonymous", externalizedKeyName="allowAnonymous", externalized=true, description="Do we allow the anonymous to pass the authentication and limit it with some paths\nto access? Default is false, and it should only be true in client-proxy.")
    boolean allowAnonymous;
    @BooleanField(configFieldName="allowBearerToken", externalizedKeyName="allowBearerToken", externalized=true, description="Allow the Bearer OAuth 2.0 token authorization to pass to the next handler with paths\nauthorization defined under username bearer. This feature is used in proxy-client\nthat support multiple clients with different authorizations.\n")
    boolean allowBearerToken;
    @MapField(configFieldName="users", externalizedKeyName="users", externalized=true, description="usernames and passwords in a list, the password can be encrypted like user2 in test.\nAs we are supporting multiple users, so leave the passwords in this file with users.\nFor each user, you can specify a list of optional paths that this user is allowed to\naccess. A special user anonymous can be used to set the paths for client without an\nauthorization header. The paths are optional and used for proxy only to authorize.\n", valueType=UserAuth.class)
    Map<String, UserAuth> users;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    public BasicAuthConfig() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigUser();
    }

    public BasicAuthConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigUser();
    }

    public static BasicAuthConfig load() {
        return new BasicAuthConfig();
    }

    public static BasicAuthConfig load(String configName) {
        return new BasicAuthConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigUser();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnableAD() {
        return this.enabled;
    }

    public void setEnableAD(boolean enabled) {
        this.enableAD = enabled;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public void setAllowAnonymous(boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
    }

    public boolean isAllowBearerToken() {
        return this.allowBearerToken;
    }

    public void setAllowBearerToken(boolean allowBearerToken) {
        this.allowBearerToken = allowBearerToken;
    }

    public Map<String, UserAuth> getUsers() {
        return this.users;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.mappedConfig.get(ENABLE_AD)) != null) {
            this.enableAD = Config.loadBooleanValue(ENABLE_AD, object);
        }
        if ((object = this.mappedConfig.get(ALLOW_ANONYMOUS)) != null) {
            this.allowAnonymous = Config.loadBooleanValue(ALLOW_ANONYMOUS, object);
        }
        if ((object = this.mappedConfig.get(ALLOW_BEARER_TOKEN)) != null) {
            this.allowBearerToken = Config.loadBooleanValue(ALLOW_BEARER_TOKEN, object);
        }
    }

    private void setConfigUser() {
        if (this.mappedConfig.get(USERS) instanceof List) {
            List userList = (List)this.mappedConfig.get(USERS);
            this.populateUsers(userList);
        } else if (this.mappedConfig.get(USERS) instanceof String) {
            String s2 = (String)this.mappedConfig.get(USERS);
            if (!(s2 = s2.trim()).startsWith("[")) {
                throw new ConfigException("The string value must be start with [ as a JSON list");
            }
            List<Map<String, Object>> userList = JsonMapper.string2List(s2);
            this.populateUsers(userList);
        } else if (this.enabled) {
            throw new ConfigException("Basic Auth is enabled but there is no users definition.");
        }
    }

    private void populateUsers(List<Map<String, Object>> userList) {
        this.users = new HashMap<String, UserAuth>();
        userList.forEach(user -> {
            if (user instanceof Map) {
                UserAuth userAuth = new UserAuth();
                user.forEach((k, v) -> {
                    if (USERNAME.equals(k)) {
                        userAuth.setUsername((String)v);
                    }
                    if (PASSWORD.equals(k)) {
                        userAuth.setPassword((String)v);
                    }
                    if (PATHS.equals(k)) {
                        if (v instanceof List) {
                            userAuth.setPaths((List)v);
                        } else {
                            throw new ConfigException("Paths must be an array of strings.");
                        }
                    }
                });
                this.users.put(userAuth.getUsername(), userAuth);
            }
        });
    }
}

