/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.audit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.IntegerField;
import com.networknt.config.schema.OutputFormat;
import com.networknt.config.schema.StringField;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="audit", configName="audit", configDescription="AuditHandler will pick some important fields from headers and tokens and logs into an audit appender\ndefined in the logback.xml configuration file.", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class AuditConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuditConfig.class);
    public static final String REQUEST_BODY = "requestBody";
    public static final String RESPONSE_BODY = "responseBody";
    private static final String HEADERS = "headers";
    private static final String AUDIT = "audit";
    private static final String STATUS_CODE = "statusCode";
    private static final String RESPONSE_TIME = "responseTime";
    private static final String AUDIT_ON_ERROR = "auditOnError";
    private static final String LOG_LEVEL_IS_ERROR = "logLevelIsError";
    private static final String MASK = "mask";
    private static final String TIMESTAMP_FORMAT = "timestampFormat";
    private static final String ENABLED = "enabled";
    private static final String REQUEST_BODY_MAX_SIZE = "requestBodyMaxSize";
    private static final String RESPONSE_BODY_MAX_SIZE = "responseBodyMaxSize";
    private Map<String, Object> mappedConfig;
    public static final String CONFIG_NAME = "audit";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", description="Enable Audit Logging", externalized=true, defaultValue=true)
    private boolean enabled;
    @BooleanField(configFieldName="mask", externalizedKeyName="mask", description="Enable mask in the audit log", externalized=true, defaultValue=true)
    private boolean mask;
    @BooleanField(configFieldName="statusCode", externalizedKeyName="statusCode", description="Output response status code.", externalized=true, defaultValue=true)
    private boolean statusCode;
    @BooleanField(configFieldName="responseTime", externalizedKeyName="responseTime", description="Output response time.", externalized=true, defaultValue=true)
    private boolean responseTime;
    private final Config config = Config.getInstance();
    private Consumer<String> auditFunc;
    @BooleanField(configFieldName="auditOnError", externalizedKeyName="auditOnError", description="when auditOnError is true:\n - it will only log when status code >= 400\nwhen auditOnError is false:\n - it will log on every request\nlog level is controlled by logLevel", externalized=true)
    private boolean auditOnError;
    @StringField(configFieldName="timestampFormat", externalizedKeyName="timestampFormat", description="the format for outputting the timestamp, if the format is not specified or invalid, will use a long value.\nfor some users that will process the audit log manually, you can use yyyy-MM-dd'T'HH:mm:ss.SSSZ as format.", externalized=true)
    private String timestampFormat;
    @ArrayField(configFieldName="headers", externalizedKeyName="headers", description="Output header elements. You can add more if you want. If multiple values, you can use a comma separated\nstring as default value in the template and values.yml. You can also use a list of strings in YAML format.\nCorrelation Id\n- X-Correlation-Id\nTraceability Id\n- X-Traceability-Id\ncaller id for metrics\n- caller_id\n", externalized=true, items=String.class, defaultValue="[\"X-Correlation-Id\", \"X-Traceability-Id\",\"caller_id\"]")
    private List<String> headerList;
    @ArrayField(configFieldName="audit", externalizedKeyName="audit", description="Output audit elements. You can add more if you want. If multiple values, you can use a comma separated\nstring as default value in the template and values.yml. You can also use a list of strings in YAML format.\nClient Id\n- client_id\nUser Id in id token, this is optional\n- user_id\nClient Id in scope/access token, this is optional\n- scope_client_id\nRequest endpoint uri@method.\n- endpoint\nService ID assigned to the service, this is optional and must be set by the service in its implementation\n- serviceId\nRequest Body, this is optional and must be set by the service in its implementation\n- requestBody\nResponse payload, this is optional and must be set by the service in its implementation\n- responseBody\n", externalized=true, items=String.class, defaultValue="[\"client_id\", \"user_id\", \"scope_client_id\", \"endpoint\", \"serviceId\"]")
    private List<String> auditList;
    @IntegerField(configFieldName="requestBodyMaxSize", externalizedKeyName="requestBodyMaxSize", description="The limit of the request body to put into the audit entry if requestBody is in the list of audit. If the\nrequest body is bigger than the max size, it will be truncated to the max size. The default value is 4096.", externalized=true, defaultValue=4096)
    private int requestBodyMaxSize;
    @IntegerField(configFieldName="responseBodyMaxSize", externalizedKeyName="responseBodyMaxSize", description="The limit of the response body to put into the audit entry if responseBody is in the list of audit. If the\nresponse body is bigger than the max size, it will be truncated to the max size. The default value is 4096.", externalized=true, defaultValue=4096)
    private int responseBodyMaxSize;

    private AuditConfig() {
        this("audit");
    }

    private AuditConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setLists();
        this.setLogLevel();
        this.setConfigData();
    }

    public static AuditConfig load() {
        return new AuditConfig();
    }

    public static AuditConfig load(String configName) {
        return new AuditConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache("audit");
        this.setLists();
        this.setLogLevel();
        this.setConfigData();
    }

    public List<String> getHeaderList() {
        return this.headerList;
    }

    public List<String> getAuditList() {
        return this.auditList;
    }

    public Consumer<String> getAuditFunc() {
        return this.auditFunc;
    }

    public boolean isAuditOnError() {
        return this.auditOnError;
    }

    public boolean isMask() {
        return this.mask;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isResponseTime() {
        return this.responseTime;
    }

    public boolean isStatusCode() {
        return this.statusCode;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean hasHeaderList() {
        return this.getHeaderList() != null && this.getHeaderList().size() > 0;
    }

    public boolean hasAuditList() {
        return this.getAuditList() != null && this.getAuditList().size() > 0;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public int getRequestBodyMaxSize() {
        return this.requestBodyMaxSize;
    }

    public int getResponseBodyMaxSize() {
        return this.responseBodyMaxSize;
    }

    Config getConfig() {
        return this.config;
    }

    private void setLogLevel() {
        this.auditFunc = this.auditOnError ? LoggerFactory.getLogger("Audit")::error : LoggerFactory.getLogger("Audit")::info;
    }

    private void setLists() {
        String s2;
        if (this.getMappedConfig().get(HEADERS) instanceof String) {
            s2 = (String)this.getMappedConfig().get(HEADERS);
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("s = " + s2);
            }
            if (s2.startsWith("[")) {
                try {
                    this.headerList = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                }
                catch (Exception e) {
                    throw new ConfigException("could not parse the headers json with a list of strings.");
                }
            } else {
                this.headerList = Arrays.asList(s2.split("\\s*,\\s*"));
            }
        } else if (this.getMappedConfig().get(HEADERS) instanceof List) {
            this.headerList = (List)this.getMappedConfig().get(HEADERS);
        } else {
            throw new ConfigException("headers list is missing or wrong type.");
        }
        if (this.getMappedConfig().get("audit") instanceof String) {
            s2 = (String)this.getMappedConfig().get("audit");
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("s = " + s2);
            }
            if (s2.startsWith("[")) {
                try {
                    this.auditList = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                }
                catch (Exception e) {
                    throw new ConfigException("could not parse the audit json with a list of strings.");
                }
            } else {
                this.auditList = Arrays.asList(s2.split("\\s*,\\s*"));
            }
        } else if (this.getMappedConfig().get("audit") instanceof List) {
            this.auditList = (List)this.getMappedConfig().get("audit");
        } else {
            throw new ConfigException("audit list is missing or wrong type.");
        }
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(STATUS_CODE);
        if (object != null) {
            this.statusCode = Config.loadBooleanValue(STATUS_CODE, object);
        }
        if ((object = this.getMappedConfig().get(RESPONSE_TIME)) != null) {
            this.responseTime = Config.loadBooleanValue(RESPONSE_TIME, object);
        }
        if ((object = this.getMappedConfig().get(AUDIT_ON_ERROR)) != null) {
            this.auditOnError = Config.loadBooleanValue(AUDIT_ON_ERROR, object);
        }
        if ((object = this.getMappedConfig().get(MASK)) != null) {
            this.mask = Config.loadBooleanValue(MASK, object);
        }
        if ((object = this.mappedConfig.get(REQUEST_BODY_MAX_SIZE)) != null) {
            this.requestBodyMaxSize = Config.loadIntegerValue(REQUEST_BODY_MAX_SIZE, object);
        }
        if ((object = this.mappedConfig.get(RESPONSE_BODY_MAX_SIZE)) != null) {
            this.responseBodyMaxSize = Config.loadIntegerValue(RESPONSE_BODY_MAX_SIZE, object);
        }
        if ((object = this.getMappedConfig().get(ENABLED)) != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        this.timestampFormat = (String)this.getMappedConfig().get(TIMESTAMP_FORMAT);
    }
}

