/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.apikey;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.apikey.ApiKey;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.schema.ArrayField;
import com.networknt.config.schema.BooleanField;
import com.networknt.config.schema.ConfigSchema;
import com.networknt.config.schema.OutputFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigSchema(configKey="apikey", configName="apikey", configDescription="ApiKey Authentication Security Configuration for light-4j", outputFormats={OutputFormat.JSON_SCHEMA, OutputFormat.YAML})
public class ApiKeyConfig {
    private static final Logger logger = LoggerFactory.getLogger(ApiKeyConfig.class);
    public static final String CONFIG_NAME = "apikey";
    public static final String ENABLED = "enabled";
    public static final String HASH_ENABLED = "hashEnabled";
    public static final String PATH_PREFIX = "pathPrefix";
    public static final String HEADER_NAME = "headerName";
    public static final String API_KEY = "apiKey";
    public static final String PATH_PREFIX_AUTHS = "pathPrefixAuths";
    @BooleanField(configFieldName="enabled", externalizedKeyName="enabled", externalized=true, defaultValue=true, description="Enable ApiKey Authentication Handler, default is false.")
    boolean enabled;
    @BooleanField(configFieldName="hashEnabled", externalizedKeyName="hashEnabled", externalized=true, description="If API key hash is enabled. The API key will be hashed with PBKDF2WithHmacSHA1 before it is\nstored in the config file. It is more secure than put the encrypted key into the config file.\nThe default value is false. If you want to enable it, you need to use the following repo\nhttps://github.com/networknt/light-hash command line tool to hash the clear text key.")
    boolean hashEnabled;
    @ArrayField(configFieldName="pathPrefixAuths", externalizedKeyName="pathPrefixAuths", externalized=true, items=ApiKey.class, description="path prefix to the api key mapping. It is a list of map between the path prefix and the api key\nfor apikey authentication. In the handler, it loops through the list and find the matching path\nprefix. Once found, it will check if the apikey is equal to allow the access or return an error.\nThe map object has three properties: pathPrefix, headerName and apiKey. Take a look at the test\nresources/config folder for configuration examples.\n")
    List<ApiKey> pathPrefixAuths;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private ApiKeyConfig() {
        this(CONFIG_NAME);
    }

    private ApiKeyConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    public static ApiKeyConfig load() {
        return new ApiKeyConfig();
    }

    public static ApiKeyConfig load(String configName) {
        return new ApiKeyConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isHashEnabled() {
        return this.hashEnabled;
    }

    public void setHashEnabled(boolean hashEnabled) {
        this.hashEnabled = hashEnabled;
    }

    public List<ApiKey> getPathPrefixAuths() {
        return this.pathPrefixAuths;
    }

    public void setPathPrefixAuths(List<ApiKey> pathPrefixAuths) {
        this.pathPrefixAuths = pathPrefixAuths;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.mappedConfig.get(HASH_ENABLED)) != null) {
            this.hashEnabled = Config.loadBooleanValue(HASH_ENABLED, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setConfigList() {
        if (this.mappedConfig.get(PATH_PREFIX_AUTHS) == null) return;
        Object object = this.mappedConfig.get(PATH_PREFIX_AUTHS);
        this.pathPrefixAuths = new ArrayList<ApiKey>();
        if (object instanceof String) {
            String s2 = (String)object;
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("pathPrefixAuth s = " + s2);
            }
            if (!s2.startsWith("[")) throw new ConfigException("pathPrefixAuth must be a list of string object map.");
            try {
                List<Map<String, Object>> values2 = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<Map<String, Object>>>(){});
                this.pathPrefixAuths = ApiKeyConfig.populatePathPrefixAuths(values2);
                return;
            }
            catch (Exception e) {
                logger.error("Exception:", e);
                throw new ConfigException("could not parse the pathPrefixAuth json with a list of string and object.");
            }
        } else {
            if (!(object instanceof List)) throw new ConfigException("pathPrefixAuth must be a list of string object map.");
            this.pathPrefixAuths = ApiKeyConfig.populatePathPrefixAuths((List)object);
        }
    }

    public static List<ApiKey> populatePathPrefixAuths(List<Map<String, Object>> values2) {
        ArrayList<ApiKey> pathPrefixAuths = new ArrayList<ApiKey>();
        for (Map<String, Object> value : values2) {
            ApiKey apiKey = new ApiKey();
            apiKey.setPathPrefix((String)value.get(PATH_PREFIX));
            apiKey.setHeaderName((String)value.get(HEADER_NAME));
            apiKey.setApiKey((String)value.get(API_KEY));
            pathPrefixAuths.add(apiKey);
        }
        return pathPrefixAuths;
    }
}

