/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.jackson.jsonSchema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kjetland.jackson.jsonSchema.JsonSchemaConfig;
import com.kjetland.jackson.jsonSchema.Utils;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class DefinitionsHandler {
    final JsonSchemaConfig config;
    private final Map<JavaType, String> class2Ref = new HashMap<JavaType, String>();
    private final ObjectNode definitionsNode = JsonNodeFactory.instance.objectNode();
    private Deque<Optional<WorkInProgress>> workInProgressStack = new LinkedList<Optional<WorkInProgress>>();
    private Optional<WorkInProgress> workInProgress = Optional.empty();

    public void pushWorkInProgress() {
        this.workInProgressStack.push(this.workInProgress);
        this.workInProgress = Optional.empty();
    }

    public void popworkInProgress() {
        this.workInProgress = this.workInProgressStack.pop();
    }

    public DefinitionInfo getOrCreateDefinition(JavaType type, VisitorSupplier visitorSupplier) throws JsonMappingException {
        String definitionName;
        String ref = this.class2Ref.get(type);
        if (ref != null) {
            if (!this.workInProgress.isPresent()) {
                return new DefinitionInfo(ref, null);
            }
            if (type != this.workInProgress.get().typeInProgress) {
                throw new IllegalStateException("Wrong type - working on " + this.workInProgress.get().typeInProgress + " - got " + type);
            }
            JsonObjectFormatVisitor visitor2 = visitorSupplier.get(type, this.workInProgress.get().nodeInProgress);
            return new DefinitionInfo(null, visitor2);
        }
        int retryCount = 0;
        String shortRef = definitionName = this.getDefinitionName(type);
        String longRef = "#/definitions/" + definitionName;
        while (this.class2Ref.containsValue(longRef)) {
            shortRef = definitionName + "_" + ++retryCount;
            longRef = "#/definitions/" + definitionName + "_" + retryCount;
        }
        this.class2Ref.put(type, longRef);
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        WorkInProgress tmp = new WorkInProgress(type, node);
        this.workInProgress = Optional.of(tmp);
        this.definitionsNode.set(shortRef, node);
        JsonObjectFormatVisitor visitor3 = visitorSupplier.get(type, node);
        this.workInProgress = Optional.empty();
        return new DefinitionInfo(longRef, visitor3);
    }

    public ObjectNode getFinalDefinitionsNode() {
        if (this.class2Ref.isEmpty()) {
            return null;
        }
        return this.definitionsNode;
    }

    private String getDefinitionName(JavaType type) {
        String baseName;
        String string = baseName = this.config.useTypeIdForDefinitionName ? type.getRawClass().getTypeName() : Utils.extractTypeName(type);
        if (type.hasGenericTypes()) {
            String containedTypeNames = IntStream.range(0, type.containedTypeCount()).mapToObj(type::containedType).map(this::getDefinitionName).collect(Collectors.joining(","));
            return baseName + "(" + containedTypeNames + ")";
        }
        return baseName;
    }

    public DefinitionsHandler(JsonSchemaConfig config) {
        this.config = config;
    }

    @FunctionalInterface
    static interface VisitorSupplier {
        public JsonObjectFormatVisitor get(JavaType var1, ObjectNode var2) throws JsonMappingException;
    }

    static class WorkInProgress {
        private final JavaType typeInProgress;
        private final ObjectNode nodeInProgress;

        WorkInProgress(JavaType typeInProgress, ObjectNode nodeInProgress) {
            this.typeInProgress = typeInProgress;
            this.nodeInProgress = nodeInProgress;
        }

        public JavaType typeInProgress() {
            return this.typeInProgress;
        }

        public ObjectNode nodeInProgress() {
            return this.nodeInProgress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkInProgress)) {
                return false;
            }
            WorkInProgress other = (WorkInProgress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JavaType this$typeInProgress = this.typeInProgress();
            JavaType other$typeInProgress = other.typeInProgress();
            if (this$typeInProgress == null ? other$typeInProgress != null : !((Object)this$typeInProgress).equals(other$typeInProgress)) {
                return false;
            }
            ObjectNode this$nodeInProgress = this.nodeInProgress();
            ObjectNode other$nodeInProgress = other.nodeInProgress();
            return !(this$nodeInProgress == null ? other$nodeInProgress != null : !((Object)this$nodeInProgress).equals(other$nodeInProgress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WorkInProgress;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            JavaType $typeInProgress = this.typeInProgress();
            result2 = result2 * 59 + ($typeInProgress == null ? 43 : ((Object)$typeInProgress).hashCode());
            ObjectNode $nodeInProgress = this.nodeInProgress();
            result2 = result2 * 59 + ($nodeInProgress == null ? 43 : ((Object)$nodeInProgress).hashCode());
            return result2;
        }

        public String toString() {
            return "DefinitionsHandler.WorkInProgress(typeInProgress=" + this.typeInProgress() + ", nodeInProgress=" + this.nodeInProgress() + ")";
        }
    }

    static class DefinitionInfo {
        private final String ref;
        private final JsonObjectFormatVisitor jsonObjectFormatVisitor;

        DefinitionInfo(String ref, JsonObjectFormatVisitor jsonObjectFormatVisitor) {
            this.ref = ref;
            this.jsonObjectFormatVisitor = jsonObjectFormatVisitor;
        }

        public String ref() {
            return this.ref;
        }

        public JsonObjectFormatVisitor jsonObjectFormatVisitor() {
            return this.jsonObjectFormatVisitor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefinitionInfo)) {
                return false;
            }
            DefinitionInfo other = (DefinitionInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ref = this.ref();
            String other$ref = other.ref();
            if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
                return false;
            }
            JsonObjectFormatVisitor this$jsonObjectFormatVisitor = this.jsonObjectFormatVisitor();
            JsonObjectFormatVisitor other$jsonObjectFormatVisitor = other.jsonObjectFormatVisitor();
            return !(this$jsonObjectFormatVisitor == null ? other$jsonObjectFormatVisitor != null : !this$jsonObjectFormatVisitor.equals(other$jsonObjectFormatVisitor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DefinitionInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $ref = this.ref();
            result2 = result2 * 59 + ($ref == null ? 43 : $ref.hashCode());
            JsonObjectFormatVisitor $jsonObjectFormatVisitor = this.jsonObjectFormatVisitor();
            result2 = result2 * 59 + ($jsonObjectFormatVisitor == null ? 43 : $jsonObjectFormatVisitor.hashCode());
            return result2;
        }

        public String toString() {
            return "DefinitionsHandler.DefinitionInfo(ref=" + this.ref() + ", jsonObjectFormatVisitor=" + this.jsonObjectFormatVisitor() + ")";
        }
    }
}

