/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.mapper;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonOrgMappingProvider
implements MappingProvider {
    @Override
    public <T> T map(Object source2, Class<T> targetType, Configuration configuration2) {
        if (source2 == null) {
            return null;
        }
        if (targetType.equals(Object.class) || targetType.equals(List.class) || targetType.equals(Map.class)) {
            return (T)this.mapToObject(source2);
        }
        return (T)source2;
    }

    @Override
    public <T> T map(Object source2, TypeRef<T> targetType, Configuration configuration2) {
        throw new UnsupportedOperationException("JsonOrg provider does not support TypeRef! Use a Jackson or Gson based provider");
    }

    private Object mapToObject(Object source2) {
        if (source2 instanceof JSONArray) {
            ArrayList<Object> mapped = new ArrayList<Object>();
            JSONArray array = (JSONArray)source2;
            for (int i = 0; i < array.length(); ++i) {
                mapped.add(this.mapToObject(array.get(i)));
            }
            return mapped;
        }
        if (source2 instanceof JSONObject) {
            HashMap<String, Object> mapped = new HashMap<String, Object>();
            JSONObject obj = (JSONObject)source2;
            for (String o : obj.keySet()) {
                String key = o.toString();
                mapped.put(key, this.mapToObject(obj.get(key)));
            }
            return mapped;
        }
        if (source2 == JSONObject.NULL) {
            return null;
        }
        return source2;
    }
}

