/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.MapFunction;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.ParseContextImpl;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.path.PathCompiler;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class JsonPath {
    private final Path path;

    private JsonPath(String jsonPath, Predicate[] filters) {
        Utils.notNull(jsonPath, "path can not be null");
        this.path = PathCompiler.compile(jsonPath, filters);
    }

    public String getPath() {
        return this.path.toString();
    }

    public static boolean isPathDefinite(String path) {
        return JsonPath.compile(path, new Predicate[0]).isDefinite();
    }

    public boolean isDefinite() {
        return this.path.isDefinite();
    }

    public <T> T read(Object jsonObject) {
        return this.read(jsonObject, Configuration.defaultConfiguration());
    }

    public <T> T read(Object jsonObject, Configuration configuration2) {
        boolean optAsPathList = configuration2.containsOption(Option.AS_PATH_LIST);
        boolean optAlwaysReturnList = configuration2.containsOption(Option.ALWAYS_RETURN_LIST);
        boolean optSuppressExceptions = configuration2.containsOption(Option.SUPPRESS_EXCEPTIONS);
        if (this.path.isFunctionPath()) {
            if (optAsPathList || optAlwaysReturnList) {
                if (optSuppressExceptions) {
                    return (T)(this.path.isDefinite() ? null : configuration2.jsonProvider().createArray());
                }
                throw new JsonPathException("Options " + (Object)((Object)Option.AS_PATH_LIST) + " and " + (Object)((Object)Option.ALWAYS_RETURN_LIST) + " are not allowed when using path functions!");
            }
            EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2);
            if (optSuppressExceptions && evaluationContext.getPathList().isEmpty()) {
                return (T)(this.path.isDefinite() ? null : configuration2.jsonProvider().createArray());
            }
            return evaluationContext.getValue(true);
        }
        if (optAsPathList) {
            EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2);
            if (optSuppressExceptions && evaluationContext.getPathList().isEmpty()) {
                return (T)configuration2.jsonProvider().createArray();
            }
            return evaluationContext.getPath();
        }
        EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2);
        if (optSuppressExceptions && evaluationContext.getPathList().isEmpty()) {
            if (optAlwaysReturnList) {
                return (T)configuration2.jsonProvider().createArray();
            }
            return (T)(this.path.isDefinite() ? null : configuration2.jsonProvider().createArray());
        }
        Object res = evaluationContext.getValue(false);
        if (optAlwaysReturnList && this.path.isDefinite()) {
            Object array = configuration2.jsonProvider().createArray();
            configuration2.jsonProvider().setArrayIndex(array, 0, res);
            return (T)array;
        }
        return res;
    }

    public <T> T set(Object jsonObject, Object newVal, Configuration configuration2) {
        Utils.notNull(jsonObject, "json can not be null");
        Utils.notNull(configuration2, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean optSuppressExceptions = configuration2.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (optSuppressExceptions) {
                return this.handleMissingPathInContext(configuration2);
            }
            throw new PathNotFoundException();
        }
        for (PathRef updateOperation : evaluationContext.updateOperations()) {
            updateOperation.set(newVal, configuration2);
        }
        return this.resultByConfiguration(jsonObject, configuration2, evaluationContext);
    }

    public <T> T map(Object jsonObject, MapFunction mapFunction, Configuration configuration2) {
        Utils.notNull(jsonObject, "json can not be null");
        Utils.notNull(configuration2, "configuration can not be null");
        Utils.notNull(mapFunction, "mapFunction can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean optSuppressExceptions = configuration2.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (optSuppressExceptions) {
                return this.handleMissingPathInContext(configuration2);
            }
            throw new PathNotFoundException();
        }
        for (PathRef updateOperation : evaluationContext.updateOperations()) {
            updateOperation.convert(mapFunction, configuration2);
        }
        return this.resultByConfiguration(jsonObject, configuration2, evaluationContext);
    }

    public <T> T delete(Object jsonObject, Configuration configuration2) {
        Utils.notNull(jsonObject, "json can not be null");
        Utils.notNull(configuration2, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean optSuppressExceptions = configuration2.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (optSuppressExceptions) {
                return this.handleMissingPathInContext(configuration2);
            }
            throw new PathNotFoundException();
        }
        for (PathRef updateOperation : evaluationContext.updateOperations()) {
            updateOperation.delete(configuration2);
        }
        return this.resultByConfiguration(jsonObject, configuration2, evaluationContext);
    }

    public <T> T add(Object jsonObject, Object value, Configuration configuration2) {
        Utils.notNull(jsonObject, "json can not be null");
        Utils.notNull(configuration2, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean optSuppressExceptions = configuration2.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (optSuppressExceptions) {
                return this.handleMissingPathInContext(configuration2);
            }
            throw new PathNotFoundException();
        }
        for (PathRef updateOperation : evaluationContext.updateOperations()) {
            updateOperation.add(value, configuration2);
        }
        return this.resultByConfiguration(jsonObject, configuration2, evaluationContext);
    }

    public <T> T put(Object jsonObject, String key, Object value, Configuration configuration2) {
        Utils.notNull(jsonObject, "json can not be null");
        Utils.notEmpty(key, "key can not be null or empty");
        Utils.notNull(configuration2, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2, true);
        if (evaluationContext.getPathList().isEmpty()) {
            boolean optSuppressExceptions = configuration2.containsOption(Option.SUPPRESS_EXCEPTIONS);
            if (optSuppressExceptions) {
                return this.handleMissingPathInContext(configuration2);
            }
            throw new PathNotFoundException();
        }
        for (PathRef updateOperation : evaluationContext.updateOperations()) {
            updateOperation.put(key, value, configuration2);
        }
        return this.resultByConfiguration(jsonObject, configuration2, evaluationContext);
    }

    public <T> T renameKey(Object jsonObject, String oldKeyName, String newKeyName, Configuration configuration2) {
        Utils.notNull(jsonObject, "json can not be null");
        Utils.notEmpty(newKeyName, "newKeyName can not be null or empty");
        Utils.notNull(configuration2, "configuration can not be null");
        EvaluationContext evaluationContext = this.path.evaluate(jsonObject, jsonObject, configuration2, true);
        for (PathRef updateOperation : evaluationContext.updateOperations()) {
            boolean optSuppressExceptions = configuration2.containsOption(Option.SUPPRESS_EXCEPTIONS);
            try {
                updateOperation.renameKey(oldKeyName, newKeyName, configuration2);
            }
            catch (RuntimeException e) {
                if (optSuppressExceptions) continue;
                throw e;
            }
        }
        return this.resultByConfiguration(jsonObject, configuration2, evaluationContext);
    }

    public <T> T read(String json) {
        return this.read(json, Configuration.defaultConfiguration());
    }

    public <T> T read(String json, Configuration configuration2) {
        Utils.notEmpty(json, "json can not be null or empty");
        Utils.notNull(configuration2, "jsonProvider can not be null");
        return this.read(configuration2.jsonProvider().parse(json), configuration2);
    }

    public <T> T read(URL jsonURL) throws IOException {
        return this.read(jsonURL, Configuration.defaultConfiguration());
    }

    public <T> T read(File jsonFile) throws IOException {
        return this.read(jsonFile, Configuration.defaultConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(File jsonFile, Configuration configuration2) throws IOException {
        T t2;
        Utils.notNull(jsonFile, "json file can not be null");
        Utils.isTrue(jsonFile.exists(), "json file does not exist");
        Utils.notNull(configuration2, "jsonProvider can not be null");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jsonFile);
            t2 = this.read(fis, configuration2);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fis);
            throw throwable;
        }
        Utils.closeQuietly(fis);
        return t2;
    }

    public <T> T read(InputStream jsonInputStream) throws IOException {
        return this.read(jsonInputStream, Configuration.defaultConfiguration());
    }

    public <T> T read(InputStream jsonInputStream, Configuration configuration2) throws IOException {
        Utils.notNull(jsonInputStream, "json input stream can not be null");
        Utils.notNull(configuration2, "configuration can not be null");
        return this.read(jsonInputStream, "UTF-8", configuration2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(InputStream jsonInputStream, String charset, Configuration configuration2) throws IOException {
        Utils.notNull(jsonInputStream, "json input stream can not be null");
        Utils.notNull(charset, "charset can not be null");
        Utils.notNull(configuration2, "configuration can not be null");
        try {
            T t2 = this.read(configuration2.jsonProvider().parse(jsonInputStream, charset), configuration2);
            return t2;
        }
        finally {
            Utils.closeQuietly(jsonInputStream);
        }
    }

    public static JsonPath compile(String jsonPath, Predicate ... filters) {
        Utils.notEmpty(jsonPath, "json can not be null or empty");
        return new JsonPath(jsonPath, filters);
    }

    public static <T> T read(Object json, String jsonPath, Predicate ... filters) {
        return JsonPath.parse(json).read(jsonPath, filters);
    }

    public static <T> T read(String json, String jsonPath, Predicate ... filters) {
        return new ParseContextImpl().parse(json).read(jsonPath, filters);
    }

    @Deprecated
    public static <T> T read(URL jsonURL, String jsonPath, Predicate ... filters) throws IOException {
        return new ParseContextImpl().parse(jsonURL).read(jsonPath, filters);
    }

    public static <T> T read(File jsonFile, String jsonPath, Predicate ... filters) throws IOException {
        return new ParseContextImpl().parse(jsonFile).read(jsonPath, filters);
    }

    public static <T> T read(InputStream jsonInputStream, String jsonPath, Predicate ... filters) throws IOException {
        return new ParseContextImpl().parse(jsonInputStream).read(jsonPath, filters);
    }

    public static ParseContext using(Configuration configuration2) {
        return new ParseContextImpl(configuration2);
    }

    @Deprecated
    public static ParseContext using(JsonProvider provider) {
        return new ParseContextImpl(Configuration.builder().jsonProvider(provider).build());
    }

    public static DocumentContext parse(Object json) {
        return new ParseContextImpl().parse(json);
    }

    public static DocumentContext parse(String json) {
        return new ParseContextImpl().parse(json);
    }

    public static DocumentContext parse(InputStream json) {
        return new ParseContextImpl().parse(json);
    }

    public static DocumentContext parse(File json) throws IOException {
        return new ParseContextImpl().parse(json);
    }

    @Deprecated
    public static DocumentContext parse(URL json) throws IOException {
        return new ParseContextImpl().parse(json);
    }

    public static DocumentContext parse(Object json, Configuration configuration2) {
        return new ParseContextImpl(configuration2).parse(json);
    }

    public static DocumentContext parse(String json, Configuration configuration2) {
        return new ParseContextImpl(configuration2).parse(json);
    }

    public static DocumentContext parse(InputStream json, Configuration configuration2) {
        return new ParseContextImpl(configuration2).parse(json);
    }

    public static DocumentContext parse(File json, Configuration configuration2) throws IOException {
        return new ParseContextImpl(configuration2).parse(json);
    }

    @Deprecated
    public static DocumentContext parse(URL json, Configuration configuration2) throws IOException {
        return new ParseContextImpl(configuration2).parse(json);
    }

    private <T> T resultByConfiguration(Object jsonObject, Configuration configuration2, EvaluationContext evaluationContext) {
        if (configuration2.containsOption(Option.AS_PATH_LIST)) {
            return (T)evaluationContext.getPathList();
        }
        return (T)jsonObject;
    }

    private <T> T handleMissingPathInContext(Configuration configuration2) {
        boolean optAsPathList = configuration2.containsOption(Option.AS_PATH_LIST);
        boolean optAlwaysReturnList = configuration2.containsOption(Option.ALWAYS_RETURN_LIST);
        if (optAsPathList) {
            return (T)configuration2.jsonProvider().createArray();
        }
        if (optAlwaysReturnList) {
            return (T)configuration2.jsonProvider().createArray();
        }
        return (T)(this.path.isDefinite() ? null : configuration2.jsonProvider().createArray());
    }
}

