/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import java.util.Comparator;
import java.util.UUID;
import java.util.function.ToIntBiFunction;

public final class UuidComparator
implements Comparator<UUID> {
    private final ToIntBiFunction<UUID, UUID> comparator;
    private static final UuidComparator INSTANCE_DEFAULT = new UuidComparator(UuidComparator::defaultCompare);
    private static final UuidComparator INSTANCE_OPAQUE = new UuidComparator(UuidComparator::opaqueCompare);

    private UuidComparator(ToIntBiFunction<UUID, UUID> comparator) {
        this.comparator = comparator;
    }

    public UuidComparator() {
        this(UuidComparator::defaultCompare);
    }

    public static UuidComparator getDefaultInstance() {
        return INSTANCE_DEFAULT;
    }

    public static UuidComparator getOpaqueInstance() {
        return INSTANCE_OPAQUE;
    }

    public static int defaultCompare(UUID uuid1, UUID uuid2) {
        UUID u2;
        UUID u1 = uuid1 != null ? uuid1 : new UUID(0L, 0L);
        UUID uUID = u2 = uuid2 != null ? uuid2 : new UUID(0L, 0L);
        if (UuidComparator.isTimeBased(u1) && UuidComparator.isTimeBased(u2)) {
            UUID rearranged1 = new UUID(u1.timestamp(), u1.getLeastSignificantBits());
            UUID rearranged2 = new UUID(u2.timestamp(), u2.getLeastSignificantBits());
            return UuidComparator.opaqueCompare(rearranged1, rearranged2);
        }
        return UuidComparator.opaqueCompare(u1, u2);
    }

    public static int opaqueCompare(UUID uuid1, UUID uuid2) {
        long d;
        long b;
        UUID u1 = uuid1 != null ? uuid1 : new UUID(0L, 0L);
        UUID u2 = uuid2 != null ? uuid2 : new UUID(0L, 0L);
        long min2 = Long.MIN_VALUE;
        long a = u1.getMostSignificantBits() + Long.MIN_VALUE;
        if (a > (b = u2.getMostSignificantBits() + Long.MIN_VALUE)) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        long c = u1.getLeastSignificantBits() + Long.MIN_VALUE;
        if (c > (d = u2.getLeastSignificantBits() + Long.MIN_VALUE)) {
            return 1;
        }
        if (c < d) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compare(UUID uuid1, UUID uuid2) {
        return this.comparator.applyAsInt(uuid1, uuid2);
    }

    private static boolean isTimeBased(UUID uuid) {
        return uuid.version() == 1 && uuid.variant() == 2;
    }
}

