/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid;

import com.github.f4b6a3.uuid.codec.StandardBinaryCodec;
import com.github.f4b6a3.uuid.codec.StandardStringCodec;
import com.github.f4b6a3.uuid.enums.UuidLocalDomain;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.factory.nonstandard.PrefixCombFactory;
import com.github.f4b6a3.uuid.factory.nonstandard.ShortPrefixCombFactory;
import com.github.f4b6a3.uuid.factory.nonstandard.ShortSuffixCombFactory;
import com.github.f4b6a3.uuid.factory.nonstandard.SuffixCombFactory;
import com.github.f4b6a3.uuid.factory.standard.DceSecurityFactory;
import com.github.f4b6a3.uuid.factory.standard.NameBasedMd5Factory;
import com.github.f4b6a3.uuid.factory.standard.NameBasedSha1Factory;
import com.github.f4b6a3.uuid.factory.standard.RandomBasedFactory;
import com.github.f4b6a3.uuid.factory.standard.TimeBasedFactory;
import com.github.f4b6a3.uuid.factory.standard.TimeOrderedEpochFactory;
import com.github.f4b6a3.uuid.factory.standard.TimeOrderedFactory;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class UuidCreator {
    public static final UuidNamespace NAMESPACE_DNS = UuidNamespace.NAMESPACE_DNS;
    public static final UuidNamespace NAMESPACE_URL = UuidNamespace.NAMESPACE_URL;
    public static final UuidNamespace NAMESPACE_OID = UuidNamespace.NAMESPACE_OID;
    public static final UuidNamespace NAMESPACE_X500 = UuidNamespace.NAMESPACE_X500;
    public static final UuidLocalDomain LOCAL_DOMAIN_PERSON = UuidLocalDomain.LOCAL_DOMAIN_PERSON;
    public static final UuidLocalDomain LOCAL_DOMAIN_GROUP = UuidLocalDomain.LOCAL_DOMAIN_GROUP;
    public static final UuidLocalDomain LOCAL_DOMAIN_ORG = UuidLocalDomain.LOCAL_DOMAIN_ORG;
    private static final UUID UUID_NIL = new UUID(0L, 0L);
    private static final UUID UUID_MAX = new UUID(-1L, -1L);
    private static final Proxy UUID1 = new Proxy(Proxy.UUID1);
    private static final Proxy UUID1_MAC = new Proxy(Proxy.UUID1_MAC);
    private static final Proxy UUID1_HASH = new Proxy(Proxy.UUID1_HASH);
    private static final Proxy UUID1_RANDOM = new Proxy(Proxy.UUID1_RANDOM);
    private static final Proxy UUID2 = new Proxy(Proxy.UUID2);
    private static final Proxy UUID2_MAC = new Proxy(Proxy.UUID2_MAC);
    private static final Proxy UUID2_HASH = new Proxy(Proxy.UUID2_HASH);
    private static final Proxy UUID2_RANDOM = new Proxy(Proxy.UUID2_RANDOM);
    private static final Proxy UUID3 = new Proxy(Proxy.UUID3);
    private static final Proxy UUID4 = new Proxy(Proxy.UUID4);
    private static final Proxy UUID4_FAST = new Proxy(Proxy.UUID4_FAST);
    private static final Proxy UUID5 = new Proxy(Proxy.UUID5);
    private static final Proxy UUID6 = new Proxy(Proxy.UUID6);
    private static final Proxy UUID6_MAC = new Proxy(Proxy.UUID6_MAC);
    private static final Proxy UUID6_HASH = new Proxy(Proxy.UUID6_HASH);
    private static final Proxy UUID6_RANDOM = new Proxy(Proxy.UUID6_RANDOM);
    private static final Proxy UUID7 = new Proxy(Proxy.UUID7);
    private static final Proxy UUID7_FAST = new Proxy(Proxy.UUID7_FAST);
    private static final Proxy UUID7_PLUS_1 = new Proxy(Proxy.UUID7_PLUS_1);
    private static final Proxy UUID7_PLUS_N = new Proxy(Proxy.UUID7_PLUS_N);
    private static final Proxy COMB_PREFIX = new Proxy(Proxy.COMB_PREFIX);
    private static final Proxy COMB_SUFFIX = new Proxy(Proxy.COMB_SUFFIX);
    private static final Proxy COMB_SHORT_PREFIX = new Proxy(Proxy.COMB_SHORT_PREFIX);
    private static final Proxy COMB_SHORT_SUFFIX = new Proxy(Proxy.COMB_SHORT_SUFFIX);

    private UuidCreator() {
    }

    public static UUID getNil() {
        return UUID_NIL;
    }

    public static UUID getMax() {
        return UUID_MAX;
    }

    public static byte[] toBytes(UUID uuid) {
        return StandardBinaryCodec.INSTANCE.encode(uuid);
    }

    public static UUID fromBytes(byte[] uuid) {
        return StandardBinaryCodec.INSTANCE.decode(uuid);
    }

    public static String toString(UUID uuid) {
        return StandardStringCodec.INSTANCE.encode(uuid);
    }

    public static UUID fromString(String uuid) {
        return StandardStringCodec.INSTANCE.decode(uuid);
    }

    public static UUID getRandomBased() {
        return UUID4.create();
    }

    public static UUID getRandomBasedFast() {
        return UUID4_FAST.create();
    }

    public static UUID getTimeBased() {
        return UUID1.create();
    }

    public static UUID getTimeBasedWithMac() {
        return UUID1_MAC.create();
    }

    public static UUID getTimeBasedWithHash() {
        return UUID1_HASH.create();
    }

    public static UUID getTimeBasedWithRandom() {
        return UUID1_RANDOM.create();
    }

    public static UUID getTimeBased(Instant instant, Integer clockseq, Long nodeid) {
        TimeBasedFactory.Builder builder = TimeBasedFactory.builder();
        if (instant != null) {
            builder.withInstant(instant);
        }
        if (clockseq != null) {
            builder.withClockSeq(clockseq.intValue());
        }
        if (nodeid != null) {
            builder.withNodeId(nodeid);
        }
        return builder.build().create();
    }

    public static UUID getTimeBasedMin(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        TimeBasedFactory.Builder builder = TimeBasedFactory.builder();
        return ((TimeBasedFactory.Builder)((TimeBasedFactory.Builder)((TimeBasedFactory.Builder)builder.withInstant(instant)).withClockSeq(0L)).withNodeId(0L)).build().create();
    }

    public static UUID getTimeBasedMax(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        TimeBasedFactory.Builder builder = TimeBasedFactory.builder();
        return ((TimeBasedFactory.Builder)((TimeBasedFactory.Builder)((TimeBasedFactory.Builder)builder.withInstant(instant)).withClockSeq(65535L)).withNodeId(0xFFFFFFFFFFFFL)).build().create();
    }

    public static UUID getTimeOrdered() {
        return UUID6.create();
    }

    public static UUID getTimeOrderedWithMac() {
        return UUID6_MAC.create();
    }

    public static UUID getTimeOrderedWithHash() {
        return UUID6_HASH.create();
    }

    public static UUID getTimeOrderedWithRandom() {
        return UUID6_RANDOM.create();
    }

    public static UUID getTimeOrdered(Instant instant, Integer clockseq, Long nodeid) {
        TimeOrderedFactory.Builder builder = TimeOrderedFactory.builder();
        if (instant != null) {
            builder.withInstant(instant);
        }
        if (clockseq != null) {
            builder.withClockSeq(clockseq.intValue());
        }
        if (nodeid != null) {
            builder.withNodeId(nodeid);
        }
        return builder.build().create();
    }

    public static UUID getTimeOrderedMin(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        TimeOrderedFactory.Builder builder = TimeOrderedFactory.builder();
        return ((TimeOrderedFactory.Builder)((TimeOrderedFactory.Builder)((TimeOrderedFactory.Builder)builder.withInstant(instant)).withClockSeq(0L)).withNodeId(0L)).build().create();
    }

    public static UUID getTimeOrderedMax(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        TimeOrderedFactory.Builder builder = TimeOrderedFactory.builder();
        return ((TimeOrderedFactory.Builder)((TimeOrderedFactory.Builder)((TimeOrderedFactory.Builder)builder.withInstant(instant)).withClockSeq(65535L)).withNodeId(0xFFFFFFFFFFFFL)).build().create();
    }

    public static UUID getTimeOrderedEpoch() {
        return UUID7.create();
    }

    public static UUID getTimeOrderedEpochFast() {
        return UUID7_FAST.create();
    }

    public static UUID getTimeOrderedEpochPlus1() {
        return UUID7_PLUS_1.create();
    }

    public static UUID getTimeOrderedEpochPlusN() {
        return UUID7_PLUS_N.create();
    }

    public static UUID getTimeOrderedEpoch(Instant instant) {
        return UUID7.create(UuidFactory.Parameters.builder().withInstant(instant).build());
    }

    public static UUID getTimeOrderedEpochMin(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        long time = instant.toEpochMilli();
        return new UUID(time << 16 | 0x7000L, Long.MIN_VALUE);
    }

    public static UUID getTimeOrderedEpochMax(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        long time = instant.toEpochMilli();
        return new UUID(time << 16 | 0x7FFFL, -4611686018427387905L);
    }

    public static UUID getNameBasedMd5(String name2) {
        return UUID3.create(UuidFactory.Parameters.builder().withName(name2).build());
    }

    public static UUID getNameBasedMd5(byte[] name2) {
        return UUID3.create(UuidFactory.Parameters.builder().withName(name2).build());
    }

    public static UUID getNameBasedMd5(UUID namespace, String name2) {
        return UUID3.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedMd5(UUID namespace, byte[] name2) {
        return UUID3.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedMd5(String namespace, String name2) {
        return UUID3.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedMd5(String namespace, byte[] name2) {
        return UUID3.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedMd5(UuidNamespace namespace, String name2) {
        return UUID3.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedMd5(UuidNamespace namespace, byte[] name2) {
        return UUID3.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedSha1(String name2) {
        return UUID5.create(UuidFactory.Parameters.builder().withName(name2).build());
    }

    public static UUID getNameBasedSha1(byte[] name2) {
        return UUID5.create(UuidFactory.Parameters.builder().withName(name2).build());
    }

    public static UUID getNameBasedSha1(UUID namespace, String name2) {
        return UUID5.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedSha1(UUID namespace, byte[] name2) {
        return UUID5.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedSha1(String namespace, String name2) {
        return UUID5.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedSha1(String namespace, byte[] name2) {
        return UUID5.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedSha1(UuidNamespace namespace, String name2) {
        return UUID5.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getNameBasedSha1(UuidNamespace namespace, byte[] name2) {
        return UUID5.create(UuidFactory.Parameters.builder().withNamespace(namespace).withName(name2).build());
    }

    public static UUID getDceSecurity(byte localDomain, int localIdentifier) {
        return UUID2.create(UuidFactory.Parameters.builder().withLocalDomain(localDomain).withLocalIdentifier(localIdentifier).build());
    }

    public static UUID getDceSecurityWithMac(byte localDomain, int localIdentifier) {
        return UUID2_MAC.create(UuidFactory.Parameters.builder().withLocalDomain(localDomain).withLocalIdentifier(localIdentifier).build());
    }

    public static UUID getDceSecurityWithHash(byte localDomain, int localIdentifier) {
        return UUID2_HASH.create(UuidFactory.Parameters.builder().withLocalDomain(localDomain).withLocalIdentifier(localIdentifier).build());
    }

    public static UUID getDceSecurityWithRandom(byte localDomain, int localIdentifier) {
        return UUID2_RANDOM.create(UuidFactory.Parameters.builder().withLocalDomain(localDomain).withLocalIdentifier(localIdentifier).build());
    }

    public static UUID getDceSecurity(UuidLocalDomain localDomain, int localIdentifier) {
        return UUID2.create(UuidFactory.Parameters.builder().withLocalDomain(localDomain).withLocalIdentifier(localIdentifier).build());
    }

    public static UUID getDceSecurityWithMac(UuidLocalDomain localDomain, int localIdentifier) {
        return UUID2_MAC.create(UuidFactory.Parameters.builder().withLocalDomain(localDomain).withLocalIdentifier(localIdentifier).build());
    }

    public static UUID getDceSecurityWithHash(UuidLocalDomain localDomain, int localIdentifier) {
        return UUID2_HASH.create(UuidFactory.Parameters.builder().withLocalDomain(localDomain).withLocalIdentifier(localIdentifier).build());
    }

    public static UUID getDceSecurityWithRandom(UuidLocalDomain localDomain, int localIdentifier) {
        return UUID2_RANDOM.create(UuidFactory.Parameters.builder().withLocalDomain(localDomain).withLocalIdentifier(localIdentifier).build());
    }

    public static UUID getPrefixComb() {
        return COMB_PREFIX.create();
    }

    public static UUID getPrefixCombMin(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        long time = instant.toEpochMilli();
        return new UUID(time << 16 | 0x4000L, Long.MIN_VALUE);
    }

    public static UUID getPrefixCombMax(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        long time = instant.toEpochMilli();
        return new UUID(time << 16 | 0x4FFFL, -4611686018427387905L);
    }

    public static UUID getSuffixComb() {
        return COMB_SUFFIX.create();
    }

    public static UUID getSuffixCombMin(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        long time = instant.toEpochMilli();
        return new UUID(16384L, Long.MIN_VALUE | time & 0xFFFFFFFFFFFFL);
    }

    public static UUID getSuffixCombMax(Instant instant) {
        Objects.requireNonNull(instant, "Null instant");
        long time = instant.toEpochMilli();
        return new UUID(-45057L, 0xBFFF000000000000L | time & 0xFFFFFFFFFFFFL);
    }

    public static UUID getShortPrefixComb() {
        return COMB_SHORT_PREFIX.create();
    }

    public static UUID getShortSuffixComb() {
        return COMB_SHORT_SUFFIX.create();
    }

    private static class Proxy
    extends UuidFactory {
        private UuidFactory factory = null;
        private Supplier<UuidFactory> supplier;
        private static final ReentrantLock lock = new ReentrantLock();
        static final Supplier<UuidFactory> UUID1 = TimeBasedFactory::new;
        static final Supplier<UuidFactory> UUID1_MAC = () -> ((TimeBasedFactory.Builder)TimeBasedFactory.builder().withMacNodeId()).build();
        static final Supplier<UuidFactory> UUID1_HASH = () -> ((TimeBasedFactory.Builder)TimeBasedFactory.builder().withHashNodeId()).build();
        static final Supplier<UuidFactory> UUID1_RANDOM = () -> ((TimeBasedFactory.Builder)TimeBasedFactory.builder().withRandomNodeId()).build();
        static final Supplier<UuidFactory> UUID2 = DceSecurityFactory::new;
        static final Supplier<UuidFactory> UUID2_MAC = () -> ((DceSecurityFactory.Builder)DceSecurityFactory.builder().withMacNodeId()).build();
        static final Supplier<UuidFactory> UUID2_HASH = () -> ((DceSecurityFactory.Builder)DceSecurityFactory.builder().withHashNodeId()).build();
        static final Supplier<UuidFactory> UUID2_RANDOM = () -> ((DceSecurityFactory.Builder)DceSecurityFactory.builder().withRandomNodeId()).build();
        static final Supplier<UuidFactory> UUID3 = NameBasedMd5Factory::new;
        static final Supplier<UuidFactory> UUID4 = RandomBasedFactory::new;
        static final Supplier<UuidFactory> UUID4_FAST = () -> ((RandomBasedFactory.Builder)RandomBasedFactory.builder().withFastRandom()).build();
        static final Supplier<UuidFactory> UUID5 = NameBasedSha1Factory::new;
        static final Supplier<UuidFactory> UUID6 = TimeOrderedFactory::new;
        static final Supplier<UuidFactory> UUID6_MAC = () -> ((TimeOrderedFactory.Builder)TimeOrderedFactory.builder().withMacNodeId()).build();
        static final Supplier<UuidFactory> UUID6_HASH = () -> ((TimeOrderedFactory.Builder)TimeOrderedFactory.builder().withHashNodeId()).build();
        static final Supplier<UuidFactory> UUID6_RANDOM = () -> ((TimeOrderedFactory.Builder)TimeOrderedFactory.builder().withRandomNodeId()).build();
        static final Supplier<UuidFactory> UUID7 = TimeOrderedEpochFactory::new;
        static final Supplier<UuidFactory> UUID7_FAST = () -> ((TimeOrderedEpochFactory.Builder)TimeOrderedEpochFactory.builder().withFastRandom()).build();
        static final Supplier<UuidFactory> UUID7_PLUS_1 = () -> TimeOrderedEpochFactory.builder().withIncrementPlus1().build();
        static final Supplier<UuidFactory> UUID7_PLUS_N = () -> TimeOrderedEpochFactory.builder().withIncrementPlusN().build();
        static final Supplier<UuidFactory> COMB_PREFIX = PrefixCombFactory::new;
        static final Supplier<UuidFactory> COMB_SUFFIX = SuffixCombFactory::new;
        static final Supplier<UuidFactory> COMB_SHORT_PREFIX = ShortPrefixCombFactory::new;
        static final Supplier<UuidFactory> COMB_SHORT_SUFFIX = ShortSuffixCombFactory::new;

        public Proxy(Supplier<UuidFactory> supplier) {
            this.supplier = supplier;
        }

        private UuidFactory get() {
            if (this.factory != null) {
                return this.factory;
            }
            lock.lock();
            try {
                if (this.factory == null) {
                    this.factory = this.supplier.get();
                }
                UuidFactory uuidFactory = this.factory;
                return uuidFactory;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public UUID create() {
            return this.get().create();
        }

        @Override
        public UUID create(UuidFactory.Parameters parameters) {
            return this.get().create(parameters);
        }
    }
}

