/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.JsonPointer;
import com.github.erosb.jsonsKema.SchemaLoaderKt;
import com.github.erosb.jsonsKema.TextLocation;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/github/erosb/jsonsKema/SourceLocation;", "Lcom/github/erosb/jsonsKema/TextLocation;", "lineNumber", "", "position", "pointer", "Lcom/github/erosb/jsonsKema/JsonPointer;", "documentSource", "Ljava/net/URI;", "<init>", "(IILcom/github/erosb/jsonsKema/JsonPointer;Ljava/net/URI;)V", "getPointer", "()Lcom/github/erosb/jsonsKema/JsonPointer;", "equals", "", "other", "", "hashCode", "getLocation", "", "toString", "trimPointerSegments", "leadingSegmentsToBeRemoved", "trimPointerSegments$json_sKema", "withPointer", "json-sKema"})
public class SourceLocation
extends TextLocation {
    @NotNull
    private final JsonPointer pointer;

    public SourceLocation(int lineNumber, int position, @NotNull JsonPointer pointer, @NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter(pointer, "pointer");
        Intrinsics.checkNotNullParameter(documentSource, "documentSource");
        super(lineNumber, position, documentSource);
        this.pointer = pointer;
    }

    public /* synthetic */ SourceLocation(int n, int n2, JsonPointer jsonPointer, URI uRI, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            uRI = SchemaLoaderKt.getDEFAULT_BASE_URI();
        }
        this(n, n2, jsonPointer, uRI);
    }

    @NotNull
    public final JsonPointer getPointer() {
        return this.pointer;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.github.erosb.jsonsKema.SourceLocation");
        SourceLocation cfr_ignored_0 = (SourceLocation)other;
        if (this.getLineNumber() != ((SourceLocation)other).getLineNumber()) {
            return false;
        }
        if (this.getPosition() != ((SourceLocation)other).getPosition()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pointer, ((SourceLocation)other).pointer)) {
            return false;
        }
        return Intrinsics.areEqual(this.getDocumentSource(), ((SourceLocation)other).getDocumentSource());
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.pointer.hashCode();
        URI uRI = this.getDocumentSource();
        result2 = 31 * result2 + (uRI != null ? uRI.hashCode() : 0);
        result2 = 31 * result2 + this.getLineNumber();
        result2 = 31 * result2 + this.getPosition();
        return result2;
    }

    @NotNull
    public final String getLocation() {
        StringBuilder sb = new StringBuilder();
        if (this.getDocumentSource() != null) {
            sb.append(this.getDocumentSource()).append(": ");
        }
        sb.append("Line " + this.getLineNumber() + ", character " + this.getPosition());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String toString() {
        return "line " + this.getLineNumber() + ", character " + this.getPosition() + ", pointer: " + this.pointer;
    }

    @NotNull
    public final SourceLocation trimPointerSegments$json_sKema(int leadingSegmentsToBeRemoved) {
        if (leadingSegmentsToBeRemoved > this.pointer.getSegments().size()) {
            throw new IllegalArgumentException("can not remove " + leadingSegmentsToBeRemoved + " segment from pointer " + this.pointer);
        }
        return new SourceLocation(this.getLineNumber(), this.getPosition(), new JsonPointer(this.pointer.getSegments().subList(leadingSegmentsToBeRemoved, this.pointer.getSegments().size())), this.getDocumentSource());
    }

    @NotNull
    public final SourceLocation withPointer(@NotNull JsonPointer pointer) {
        Intrinsics.checkNotNullParameter(pointer, "pointer");
        return new SourceLocation(this.getLineNumber(), this.getPosition(), pointer, this.getDocumentSource());
    }
}

