/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.token;

import com.ethlo.time.internal.util.ErrorUtil;
import com.ethlo.time.token.DateTimeToken;
import java.text.ParsePosition;

public class SeparatorToken
implements DateTimeToken {
    private final char separator;

    public SeparatorToken(char separator) {
        this.separator = separator;
    }

    @Override
    public int read(String text2, ParsePosition parsePosition) {
        int index = parsePosition.getIndex();
        if (text2.length() > index && text2.charAt(index) == this.separator) {
            parsePosition.setIndex(index + 1);
        } else if (text2.length() <= index) {
            ErrorUtil.raiseUnexpectedEndOfText(text2, text2.length());
        } else if (text2.charAt(index) != this.separator) {
            ErrorUtil.raiseUnexpectedCharacter(text2, index, this.separator);
        }
        parsePosition.setIndex(index + 1);
        return 1;
    }

    public String toString() {
        return "separator: " + this.separator;
    }
}

