package net.lightapi.exporter;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class EventMatcher {
    private final Set<String> normalizedPrefixes;
    private final boolean matchAll;

    public EventMatcher(String[] typePrefixes) {
        this.matchAll = Arrays.stream(typePrefixes).anyMatch("all"::equalsIgnoreCase);
        this.normalizedPrefixes = matchAll
                ? null
                : Arrays.stream(typePrefixes)
                .map(String::toLowerCase)
                .collect(Collectors.toSet());
    }

    public boolean matchesEvent(String eventType) {
        if (matchAll) return true;
        if (eventType == null) return false;

        String prefix = extractPrefix(eventType).toLowerCase();
        return normalizedPrefixes.contains(prefix);
    }

    private String extractPrefix(String eventType) {
        // Handle null/empty and strip "Event" suffix if present
        if (eventType == null || eventType.isEmpty()) {
            return "";
        }

        // Remove "Event" suffix if exists (optional)
        String processed = eventType.endsWith("Event")
                ? eventType.substring(0, eventType.length() - 5)
                : eventType;

        // Find where the next uppercase letter appears after first char
        for (int i = 1; i < processed.length(); i++) {
            if (Character.isUpperCase(processed.charAt(i))) {
                return processed.substring(0, i);
            }
        }
        return processed;  // No uppercase found, return whole string
    }
}
