
package net.lightapi.portal.deployment.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * delete a platform for the deployment service
 */
@ServiceHandler(id="lightapi.net/deployment/deletePlatform/0.1.0")
public class DeletePlatform extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeletePlatform.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.PLATFORM_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_PLATFORM;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the platformId in the data section.
        return (String) map.get("platformId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
