
package net.lightapi.portal.deployment.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Delete a deployment instance in the portal-view UI deployment menu.
*/
@ServiceHandler(id="lightapi.net/deployment/deleteDeploymentInstance/0.1.0")
public class DeleteDeploymentInstance extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteDeploymentInstance.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.DEPLOYMENT_INSTANCE_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_DEPLOYMENT_INSTANCE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the deploymentId in the data section.
        return (String) map.get("deploymentInstanceId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}

