
package net.lightapi.portal.deployment.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.Util;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create a platform for the deployment service
 */
@ServiceHandler(id="lightapi.net/deployment/createPlatform/0.1.0")
public class CreatePlatform extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreatePlatform.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.PLATFORM_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_PLATFORM;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the platformId in the data section.
        return (String) map.get("platformId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("platformId", UuidUtil.getUUID().toString());
        return Success.of(map);
    }
}
