
package net.lightapi.portal.deployment.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create a pipeline for a host
 */
@ServiceHandler(id="lightapi.net/deployment/createPipeline/0.1.0")
public class CreatePipeline extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreatePipeline.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.PIPELINE_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_PIPELINE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the pipelineId in the data section.
        return (String) map.get("pipelineId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("pipelineId", UuidUtil.getUUID().toString());
        return Success.of(map);
    }

}
