/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.deployment.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/deployment/updateDeploymentInstance/0.1.0")
public class UpdateDeploymentInstance
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateDeploymentInstance.class);

    protected String getCloudEventType() {
        return "DeploymentInstanceUpdatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String runtimeEnv;
        String systemEnv;
        String instanceId;
        String hostId;
        Result pipelineResult;
        String serviceId = (String)map.get("serviceId");
        String legId = (String)map.get("legId");
        if (legId != null && !legId.isBlank()) {
            map.put("serviceId", serviceId + "-" + legId);
        }
        if ((pipelineResult = HybridQueryClient.getDeploymentInstancePipeline((HttpServerExchange)exchange, (String)(hostId = (String)map.get("hostId")), (String)(instanceId = (String)map.get("instanceId")), (String)(systemEnv = (String)map.get("systemEnv")), (String)(runtimeEnv = (String)map.get("runtimeEnv")))).isFailure()) {
            return Failure.of((Status)pipelineResult.getError());
        }
        String pipelineId = (String)pipelineResult.getResult();
        map.put("pipelineId", pipelineId);
        return Success.of(map);
    }
}

