/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.deployment.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/deployment/createDeployment/0.1.0")
public class CreateDeployment
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateDeployment.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static final String GENERIC_EXCEPTION = "ERR10014";

    protected String getCloudEventType() {
        return "DeploymentCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("deploymentId", UuidUtil.getUUID().toString());
        return Success.of(map);
    }

    protected Result<Map<String, Object>> additionalAction(HttpServerExchange exchange, Map<String, Object> map, String userId, String host) {
        try {
            String platformType = (String)map.get("platformType");
            if (logger.isTraceEnabled()) {
                logger.trace("platformType: {}", (Object)platformType);
            }
            if (platformType == null || platformType.isBlank()) {
                logger.error("Missing or empty platformType in startDeployment request.");
                return Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"platformType"}));
            }
        }
        catch (Exception e) {
            logger.error("Error during platform deployment", (Throwable)e);
            return Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return Success.of(map);
    }
}

