
package net.lightapi.portal.deployment.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * update the platform job id from the deployment executor service. This is used to update the job id.
*/
@ServiceHandler(id="lightapi.net/deployment/updateDeploymentJobId/0.1.0")
public class UpdateDeploymentJobId extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateDeploymentJobId.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.DEPLOYMENT_UPDATED_EVENT; // TODO implement a new event type for job id update
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
