
package net.lightapi.portal.deployment.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Update deployment details from the deployment admin page. This is for admin or the deployment owner only.
 */
@ServiceHandler(id="lightapi.net/deployment/updateDeployment/0.1.0")
public class UpdateDeployment extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateDeployment.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.DEPLOYMENT_UPDATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
