
package net.lightapi.portal.deployment.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Delete deployment from the deployment admin page. This is for admin or the deployment owner only.
 */
@ServiceHandler(id="lightapi.net/deployment/deleteDeployment/0.1.0")
public class DeleteDeployment extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteDeployment.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.DEPLOYMENT_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
