
package net.lightapi.portal.deployment.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import com.networknt.utility.Util;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import net.lightapi.portal.platform.AnsiblePlatform;
import net.lightapi.portal.platform.DeploymentPlatformHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**'
 * create a deployment for the given product.
 */
@ServiceHandler(id="lightapi.net/deployment/createDeployment/0.1.0")
public class CreateDeployment extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateDeployment.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static final String GENERIC_EXCEPTION = "ERR10014";
    @Override
    protected String getCloudEventType() {
        return PortalConstants.DEPLOYMENT_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("deploymentId", UuidUtil.getUUID().toString());
        return Success.of(map);
    }

    /**
     * Invoke platform to start a deployment job, then add returned fields (jobId, etc.) to cloud event payload.
     */
    @Override
    protected Result<Map<String, Object>> additionalAction(HttpServerExchange exchange, Map<String, Object> map, String userId, String host) {
        try {
            String platformType = (String) map.get("platformType");
            if(logger.isTraceEnabled()) logger.trace("platformType: {}", platformType);
            if (platformType == null || platformType.isBlank()) {
                logger.error("Missing or empty platformType in startDeployment request.");
                return Failure.of(new Status(OBJECT_NOT_FOUND, "platformType"));
            }
            /*
            // Currently only supports Ansible
            DeploymentPlatformHandler handler;
            if ("ansible".equalsIgnoreCase(platformType)) {
                handler = new AnsiblePlatform();
            } else {
                logger.error("Unsupported platformType: {}", platformType);
                return Result.failure("Unsupported platformType: " + platformType);
            }

            // Start the deployment and merge jobId etc. into the outgoing cloud event payload
            Map<String, Object> response = handler.startDeployment(map);
            if (response != null && !response.isEmpty()) {
                map.putAll(response);
                logger.info("Deployment started with response: {}", response);
            } else {
                logger.warn("Deployment triggered but response was null or empty.");
            }
            */
        } catch (Exception e) {
            logger.error("Error during platform deployment", e);
            return Failure.of(new Status(GENERIC_EXCEPTION, e.getMessage()));
        }
        return Success.of(map);
    }

}
