/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.config.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/config/updateConfigProductVersion/0.1.0")
public class UpdateConfigProductVersion
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateConfigProductVersion.class);
    private static final Base64.Encoder encoder = Base64.getMimeEncoder();

    protected String getCloudEventType() {
        return "ConfigProductVersionUpdatedEvent";
    }

    public String getCloudEventAggregateType() {
        return "configProperty";
    }

    public String getCloudEventAggregateId(Map<String, Object> map) {
        return (String)map.get("propertyId");
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String propertyId;
        String configId = (String)map.get("configId");
        Result configPropertyResult = HybridQueryClient.getConfigPropertyByPropertyId((HttpServerExchange)exchange, (String)configId, (String)(propertyId = (String)map.get("propertyId")));
        if (configPropertyResult.isFailure()) {
            return Failure.of((Status)configPropertyResult.getError());
        }
        String propertyType = JsonMapper.string2Map((String)((String)configPropertyResult.getResult())).get("propertyType").toString();
        if (propertyType.equals("Cert") || propertyType.equals("File")) {
            String propertyValue = (String)map.remove("propertyValue");
            String encodedData = encoder.encodeToString(propertyValue.getBytes(StandardCharsets.UTF_8));
            map.put("propertyValue", encodedData);
        }
        return Success.of(map);
    }
}

