/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.config.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/config/createConfigInstanceFile/0.1.0")
public class CreateConfigInstanceFile
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateConfigInstanceFile.class);
    private static final Base64.Encoder encoder = Base64.getMimeEncoder();

    protected String getCloudEventType() {
        return "ConfigInstanceFileCreatedEvent";
    }

    public String getCloudEventAggregateType() {
        return "instanceFile";
    }

    public String getCloudEventAggregateId(Map<String, Object> map) {
        return (String)map.get("instanceFileId");
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("instanceFileId", UuidUtil.getUUID());
        String fileType = (String)map.get("fileType");
        String fileValue = (String)map.get("fileValue");
        if (fileType.equals("File") && fileValue != null && !fileValue.isEmpty()) {
            String encodedData = encoder.encodeToString(fileValue.getBytes(StandardCharsets.UTF_8));
            map.put("fileValue", encodedData);
        }
        return Success.of(map);
    }
}

