
package net.lightapi.portal.config.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * delete config instance file command handler.
*/
@ServiceHandler(id="lightapi.net/config/updateConfigInstanceFile/0.1.0")
public class UpdateConfigInstanceFile extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateConfigInstanceFile.class);
    private static final Base64.Encoder encoder = Base64.getMimeEncoder();

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CONFIG_INSTANCE_FILE_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE_FILE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceFileId in the data section.
        return (String) map.get("instanceFileId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String fileType = (String)map.get("fileType");
        String fileValue = (String)map.get("fileValue");
        if(fileType.equals("File") && fileValue != null && !fileValue.isEmpty()) {
            // need to encode the value with base64
            String encodedData = encoder.encodeToString(fileValue.getBytes(StandardCharsets.UTF_8));
            map.put("fileValue", encodedData);
        }
        return Success.of(map);
    }

}