
package net.lightapi.portal.config.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * update config for deployment instance command handler.
*/
@ServiceHandler(id="lightapi.net/config/updateConfigDeploymentInstance/0.1.0")
public class UpdateConfigDeploymentInstance extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateConfigDeploymentInstance.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CONFIG_DEPLOYMENT_INSTANCE_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_CONFIG_PROPERTY;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the propertyId in the data section.
        return (String) map.get("propertyId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
